/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdTracker.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 95/03/24 18:48:10 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Code for the various tracker commands.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	CmdTracker.C,v $
 * Revision 1.2  95/03/24  18:48:10  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1994/09/15  07:04:49  dalke
 * Initial revision
 *
 ****************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /private/auto143000131/vmdsrc/vmd/billh/src/RCS/CmdTracker.C,v 1.2 95/03/24 18:48:10 billh Exp $";
#endif

#include "CmdTracker.h"
#include "TrackerList.h"
#include "Tracker.h"
#include "UIVR.h"
#include "Global.h"

/////////////////////////// Start a tracker
CmdTrackerStart::CmdTrackerStart(int newavailnum,char *newhostname,int id)
	: Command(Command::TRACKER_START, id) {
    
  hostname = stringdup(newhostname);
  availnum = newavailnum;
  
  // the +1 is because most people are 1 based
  *cmdText << "tracker start " << availnum + 1;
  if(newhostname)
    *cmdText << " on " << hostname;
  *cmdText << ends;
}

CmdTrackerStart::CmdTrackerStart(int newavailnum, int id)
	: Command(Command::TRACKER_START, id) {
    
  hostname = stringdup("");
  availnum = newavailnum;
  
  // the +1 is because most people are 1 based
  *cmdText << "tracker start " << availnum + 1 << ends;
}

CmdTrackerStart::~CmdTrackerStart( void) {
  delete [] hostname;
}

int CmdTrackerStart::do_execute(void) {
  if(trackerList)
    return (trackerList -> start_avail(availnum, hostname)) == TRACKER_OK;
  else
    return FALSE;    
}


/////////////////////////// Pause a tracker, given its number on the list
CmdTrackerPause::CmdTrackerPause(int tmptrackernum, int fromUIid)
	: Command(Command::TRACKER_PAUSE, fromUIid) {
    
  trackernum = tmptrackernum;
  
  // the +1 is because most people are 1 based
  *cmdText << "tracker pause " << trackernum + 1 << ends;
}

int CmdTrackerPause::do_execute(void) {
  if(trackerList && trackerList->tracker(trackernum)) {
    trackerList -> tracker(trackernum) -> pause();
    return TRUE;
  } else {
    return FALSE;
  }
}


/////////////////////////// Pause a tracker, given its number on the list
CmdTrackerUnpause::CmdTrackerUnpause(int tmptrackernum, int fromUIid)
	: Command(Command::TRACKER_UNPAUSE, fromUIid) {
    
  trackernum = tmptrackernum;
  
  // the +1 is because most people are 1 based
  *cmdText << "tracker unpause " << trackernum + 1 << ends;
}

int CmdTrackerUnpause::do_execute(void) {
  if(trackerList && trackerList->tracker(trackernum)) {
    trackerList -> tracker(trackernum) -> unpause();
    return TRUE;
  } else {
    return FALSE;
  }
}


/////////////////////////// list all the available trackers
CmdTrackerListAvail::CmdTrackerListAvail(int fromUIid)
	: Command(Command::TRACKER_LIST_AVAIL, fromUIid) {
  *cmdText << "tracker list avail" << ends;
}

int CmdTrackerListAvail::do_execute(void) {
  int i = trackerList -> num_avail();
  if (i==0) {
    msgInfo << "  No trackers are available." << sendmsg;
  } else {
    msgInfo << "Available trackers:\n" << sendmsg;
    for (int j=0; j<i; j++)
      msgInfo << " " << j+1 << "   " << trackerList -> avail_name(j) << sendmsg;
  }
  return TRUE;
}


/////////////////////////// list all running trackers
CmdTrackerList::CmdTrackerList(int fromUIid)
	: Command(Command::TRACKER_LIST, fromUIid) {
  *cmdText << "tracker list" << ends;
}


int CmdTrackerList::do_execute(void) {
  int i = trackerList -> num();
  if (i == 0 ) {
    msgInfo << "  No trackers are running.\n" << sendmsg;
  } else {
    msgInfo << "Running trackers:\n" << sendmsg;
    for (int j=0; j<i; j++) {
      msgInfo << " " << j+1;
      if (trackerList->tracker(j)->paused())
        msgInfo << " (paused) ";
      else
        msgInfo << "          ";
      msgInfo  << trackerList -> name(j) << '\n' << sendmsg;
    }
  }
  return TRUE;
}


/////////////////////////// print the current location of a tracker/ sensor pair
CmdTrackerLoc::CmdTrackerLoc(int tracker, int sensor, int fromUIid)
	: Command(Command::TRACKER_LOC, fromUIid) {

  *cmdText << "tracker location " << tracker+1 << " " << sensor+1 << ends;
  trackernum = tracker;
  sensornum = sensor;
}


// return the current location (x,y,z) of a tracker/sensor pair
int CmdTrackerLoc::do_execute(void) {
  float x,y,z;
  (trackerList -> tracker(trackernum)) -> get_position(sensornum, x, y, z);
  msgInfo << "Tracker: " << trackernum+1 << "  Sensor: " << sensornum+1;
  msgInfo << "   \nx= " << x << " y= " << y << " z= "<< z << sendmsg;
  return TRUE;
}
