/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Command.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.22 $	$Date: 95/03/24 18:48:27 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *     This file contains the base definition of the Command object.
 *  The idea is that all actions should be instantiated as
 *  a derivitive of a Command object and placed in a command queue.
 *  At every event loop, the commands are read off the current command
 *  queue and told to "execute".  When each command
 *  is finished, all of the UIs are notified that a command of some 
 *  "cmdtype" executed, so that the UI can update its information 
 *  if so desired.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	Command.h,v $
 * Revision 1.22  95/03/24  18:48:27  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.21  1995/03/04  05:09:25  billh
 * Added geometry labelling commands.
 *
 * Revision 1.20  95/02/26  22:20:50  billh
 * Added EXTERNAL command names
 * 
 * Revision 1.19  1995/02/19  20:57:39  billh
 * Added PICK commands.
 *
 * Revision 1.18  94/12/05  07:52:28  billh
 * Added color editing commands.
 * 
 * Revision 1.17  94/11/24  07:27:03  dalke
 * Added RENDER and RENDERLIST
 * 
 * Revision 1.16  1994/11/22  02:32:09  billh
 * Added ANIM_READ, ANIM_WRITE, ANIM_DELETE.
 *
 * Revision 1.15  94/11/03  09:59:44  dalke
 * Added TOOL_COMMAND
 * 
 * Revision 1.14  1994/11/02  07:31:00  billh
 * Added commands to change display screen size and distance to screen.
 *
 * Revision 1.13  94/10/26  23:21:34  billh
 * Added routines to change the settings for graphics representations
 * (MOL_MODREP, MOL_MODREPITEM).
 * 
 * Revision 1.12  94/10/21  03:53:08  billh
 * Added SIM_ command enums
 * 
 * Revision 1.11  1994/10/20  01:31:42  billh
 * Added commands for animation.
 *
 * Revision 1.10  1994/10/04  20:29:22  billh
 * Changes to get to compile on HP's ... not there yet,though.
 *
 * Revision 1.9  1994/10/03  08:32:14  dalke
 * Added CmdTool Commands
 *
 * Revision 1.8  1994/10/01  06:00:01  billh
 * execute no longer virtual.
 * Added Remote commands.
 *
 * Revision 1.7  94/09/23  00:43:34  billh
 * Added new molecule commands.
 * 
 * Revision 1.6  94/09/17  00:12:17  billh
 * Added first set of molecule command codes.
 * 
 * Revision 1.5  94/09/14  21:03:43  dalke
 * Added more Tracker commands
 * 
 * Revision 1.4  1994/09/12  20:53:36  billh
 * Added CmdResetView command (RESETVIEW).
 *
 * Revision 1.3  94/09/07  07:47:49  dalke
 * Added commands for Tracker (Start and Pause)
 * 
 * Revision 1.2  1994/08/26  00:00:50  billh
 * Added STOPROT command.
 *
 * Revision 1.1  94/08/24  03:10:37  billh
 * Initial revision
 * 
 ***************************************************************************/
#ifndef COMMAND_H
#define COMMAND_H

#include <strstream.h>
#include <iostream.h>
#include "Inform.h"


// The Command object
// Derived classes must provide a unique constructor, destructor, and
// 'execute' routine.
class Command {

  public:
    // ALL the commands types must be in this enumeration.  The last element
    // must be "TOTAL" and the sequence must start at zero.  This is because
    // we reference Command::TOTAL to figure out how many commands there are.
    enum Cmdtype { NOTHING,
        WIN_EVENT, GUI_EVENT, TEXT_EVENT,
	SHELL, HELP, RESET, QUIT, DEBUG, 
	ROTATE, TRANSLATE, SCALE, ROCKON, ROCKOFF, STOPROT, RESETVIEW,
	ANIM_DIRECTION, ANIM_JUMP, ANIM_SKIP, ANIM_STYLE, ANIM_SPEED,
	ANIM_READ, ANIM_WRITE, ANIM_DELETE,
	COLOR_NAME, COLOR_CHANGE, COLOR_SCALE_METHOD, COLOR_SCALE_MIDPOINT,
	COLOR_SCALE_MIN, COLOR_SCALE_MAX,
	DISP_RESHAPE, DISP_STEREO, DISP_EYESEP, DISP_FOCALLEN,
	DISP_LIGHT_ON, DISP_LIGHT_HL, DISP_LIGHT_ROT, DISP_MATERIALS_CHANGE,
	DISP_CLIP, DISP_DEPTHCUE, DISP_ANTIALIAS, CMD_AXES, CMD_STAGE,
	DISP_SCRHEIGHT, DISP_SCRDIST,
	EXTERNAL_START, EXTERNAL_END,
	LABEL_ADD, LABEL_LIST, LABEL_SHOW, LABEL_DELETE, LABEL_GRAPH,
	MENU_SHOW, MENU_MOVE, MENU_LOC,
	MOL_NEW, MOL_LIST, MOL_DEL, MOL_ACTIVE, MOL_FIX, MOL_ON, MOL_TOP,
	MOL_SELECT, MOL_REP, MOL_COLOR, MOL_ADDREP, MOL_MODREP, MOL_DELREP,
	MOL_MODREPITEM,
	PICK_START, PICK_MOVE, PICK_END,
	REMOTE_INIT, REMOTE_CANCEL, REMOTE_LIST, REMOTE_NEW, REMOTE_ATTACH,
	REMOTE_RUN, REMOTE_SETOPT, REMOTE_READOPT, REMOTE_WRITEOPT,
	REMOTE_CHANGE_SETTING,
	RENDER, RENDERLIST,
	SIM_SETPARAM, SIM_PATCHDISP, SIM_TOP, SIM_DETACH, SIM_KILL, SIM_LIST,
	TOOL_INFO, TOOL_SIZE, TOOL_OFFSET, TOOL_PUSH, TOOL_POP,
	TOOL_REPLACE, TOOL_COMMAND,
	TRACKER_START, TRACKER_PAUSE, TRACKER_LIST, TRACKER_LIST_AVAIL,
	TRACKER_LOC, TRACKER_UNPAUSE,
	TOTAL
    };

    char cmdtextbuf[256];	// storage for text rep of this command

  private:
    Cmdtype mytype;	//  This is used to distinguish between "Commands"
    int UIid;		// the id of the UI that made me (or -1 for none)
              		// This is used if a UI wants a quick way to figure out
			// if the command came from itself

  protected:
    // stream-based object to format text
    ostrstream *cmdText;

    // virtual function to allow each object to do a different action.
    // called by 'execute'.
    // By default, does nothing.
    virtual int do_execute(void);

  public:
    // constructor ... command type, max length of text command, UI id
    // constructor for derived class should print text rep of this command
    // to the strstream 'cmdText'
    Command(Cmdtype, int);

    // destructor; free string spaced used for text rep of this command
    virtual ~Command(void);

    // Do the action specified for this command.  Return success.
    int execute(void);

    //
    // info about this Command
    //
    
    // return unique ID code of this command
    Cmdtype gettype( void) { return mytype; }

    // the id of the user interface which created this command.  If (-1),
    // unknown (or none).
    int getUIid(void) { return UIid; }        // get the UI id field

    //
    // routines to print out data
    //
    
    // print string with text rep of this command to the given ostream
    friend ostream& operator<<(ostream &o, Command &cmd) {
      o << cmd.cmdtextbuf;
      return o;
    }
    
    // print string with text rep of this command to the given Inform obj
    friend Inform& operator<<(Inform &o, Command &cmd) {
      o << cmd.cmdtextbuf;
      return o;
    }

};

#endif
