/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: FilesFormsObj.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 95/03/24 18:49:23 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu to load a new molecule from a set of files.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	FilesFormsObj.h,v $
 * Revision 1.3  95/03/24  18:49:23  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.2  1994/11/27  08:00:29  billh
 * Changed format dramatically; now selects type of struct/coor file
 * combination preferred, and displays "Please wait" message when reading
 * in a molecule.
 *
 * Revision 1.1  1994/10/01  03:08:43  billh
 * Initial revision
 *
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef FILESFORMSOBJ_H
#define FILESFORMSOBJ_H

#include "FormsObj.h"


class FilesFormsObj : public FormsObj {

private:
  // select a filename. args are fname input object, file type, and prompt
  void choose_filename(FL_OBJECT *, int, char *);

  // reset the molecule file type based on the given value
  void reset_mol_type(int);

protected:
  // check if the given forms pointer is one for this menu, and generate
  // a command if necessary.  Return 'TRUE' if the pointer is for an object
  // in this menu.
  virtual int check(FL_OBJECT *);

  // do form-specific acting on commands ... no need here
  virtual int forms_act_on_command(int, Command *, int);

public:
  // class constructor and destructor
  FilesFormsObj(UIList *, CommandQueue *, int, int, int * = NULL);

  //
  // virtual routines for UI init/display
  //
  
  // initialize the user interface
  virtual void init(void);
  
  // reset the user interface (forces update of all info displays)
  virtual void reset(void);

  // update the interface display for each screen redraw; only if
  // necessary ... here, not so
  // virtual void update(void);

};

#endif
