/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Fragment.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 95/03/24 18:49:27 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * A Fragment contains a list of residues which are connected
 * each other, and to no one else.  This is at the residue
 * level, and not the atom level.  The residue numbers are the
 * unique_resid as assigned in BaseMolecule
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	Fragment.h,v $
 * Revision 1.2  95/03/24  18:49:27  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1994/11/26  07:43:08  dalke
 * Initial revision
 *
 ***************************************************************************/


#ifndef FRAGMENT_H
#define FRAGMENT_H

#include "ResizeArray.h"
// this is not derived from ResizeArray because the compilier doens't
// like it when I do that
class Fragment {
public:
  ResizeArray<int> residues;
  
  Fragment(void) : residues(1) {
  }
  
  int num(void) { return residues.num(); }
  operator [](int i) { return residues[i]; }
  void append(int i) { residues.append(i); }
};

#endif
