/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: GLMouse.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.7 $	$Date: 95/03/24 18:49:34 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The GL-Specific Mouse object; this uses the GL library to access the
 * state of the mouse, and uses a GL pop-up menu accessed by pressing the
 * third button for the Mouse UI commands.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	GLMouse.h,v $
 * Revision 1.7  95/03/24  18:49:34  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.6  1995/03/17  23:40:28  billh
 * No longer allows for angular velocity; instead, has pop-up menu
 * option to rock and spin the scene.
 *
 * Revision 1.5  1995/03/04  05:13:35  billh
 * Added more keyboard controls; changed so that pick mode 1
 * is used when the left button is clicked, and pick mode 2 is
 * used when the middle button is clicked.
 *
 * Revision 1.4  1995/02/22  03:57:58  billh
 * Now supports picking objects with a 2D or 3D pointer.
 * Issues CmdPick commands; adds a submenu for the PickModes, similar to
 * changing to rotate or translate modes.
 * Has a current pick mode; setes mouse mode via keyboard commands as well.
 *
 * Revision 1.3  94/11/27  07:57:27  billh
 * Changed to have separate menu on/menu off selections.
 * 
 * Revision 1.2  1994/11/09  03:43:18  billh
 * Added support to check state of function keys as if they were mouse buttons.
 *
 * Revision 1.1  1994/10/28  18:34:46  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef GLMOUSE_OBJ_H
#define GLMOUSE_OBJ_H

// this is the GL version
#include <gl/gl.h>
#include <gl/device.h>
#include "Mouse.h"


class GLMouse : public Mouse {

private:
  //
  // pop-up menu (right mouse button) data
  //
  
  // menu identifiers
  long popMain, popStereo, popMouseMode, popPickMode, popLight, popLightToggle;
  long popMenuList, popoffMenuList, popAnimate, popSpin;
  
  // do we need to free up the previous menu?
  int freeMain, freeStereo, freeMouseMode, freePickMode;
  int freeLight, freeLightToggle, freeMenuList, freeAnimate, freeSpin;

  // routine to create the pop-up menu
  void create_popup_menu(void);

  // do action when the mouse is moved
  void mouse_moved(int, int);

public:
  // constructor/destructor
  GLMouse(UIList *, CommandQueue *);
  virtual ~GLMouse(void);
  
  //
  // routines to query about the status of the mouse
  //

  // return whether the given button is down (TRUE) or up (FALSE)
  virtual int button_down(int);

  //
  // routines used to deal with the current mouse mode
  //

  // set the current move mode
  virtual int move_mode(MoveMode, int = 0);
  
  //
  // routines used to deal with the current picking mode
  //

  // set the pick mode for this mouse (does things like change cursor style)
  // return success.
  virtual int pick_mode(int);

  //
  // virtual routines for UI init/display
  // THE DERIVED CLASS, IF NECESSARY, SHOULD PROVIDE THEIR OUT VERSIONS,
  // AND THEN CALL THESE ROUTINES AS WELL
  //
   
  // reset the user interface (force update of all info displays)
  virtual void reset(void);
  
  //
  // virtual routines for entering/processing commands and events
  //
  
  // update the display due to a command being executed.  Return whether
  // any action was taken on this command.
  // Arguments are the command type, command object, and the 
  // success of the command (T or F).
  virtual int act_on_command(int, Command *, int );
  
  // check for an event, and queue it if found.  Return TRUE if an event
  // was generated.
  virtual int check_event(void);
 
};

#endif
