/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: LightList.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 95/03/24 18:50:21 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A list of Light objects; used to select a single active one and allow
 * the user to manipulate it.  Also provides an initial set of default lights.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	LightList.h,v $
 * Revision 1.3  95/03/24  18:50:21  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.2  1995/01/30  21:02:56  billh
 * No longer derived from DLinkList; but routines put in to make it
 * LOOK like it is one, so the rest of the vmd code does not have to
 * be changed.  Now it just uses a simple array to store the Light
 * pointers, which is smaller and faster.
 *
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef LIGHTLIST_H
#define LIGHTLIST_H

#include "Light.h"
#include "DisplayDevice.h"
extern class Scene;
extern class Matrix4;

// defines for this class
#define MAX_DISP_LIGHTS		DISP_LIGHTS


class LightList {

private:
  // simple array which stores the lights in this list.  There is a
  // maximum of MAX_DISP_LIGHTS lights
  Light *ltList[MAX_DISP_LIGHTS];

  // number of lights currently in the list, and the 'current' light
  int numLights, currLight;

public:
  LightList(Scene *);
  virtual ~LightList(void);
  
  //
  // operations to rotate the current light
  //

  void add_rot(float x, char axis);
  void add_rot(Matrix4 &);
  void set_rot(Matrix4 &);

  //
  // routines to have this class mimic a DLinkList (but it is simply
  // an array, to make it easier and smaller)
  //
  
  // return the Nth light, but don't change the current one
  Light *item(int n) {
    Light *retval = NULL;
    if(n >= 0 && n < numLights)
      retval = ltList[n];
    return retval;
  }

  // return the current light
  Light *current(void) {
    Light *retval = NULL;
    if(currLight >= 0)
      retval = ltList[currLight];
    return retval;
  }

  // return whether there is a current light
  int is_current(void) { return (current() != NULL); }

  // set the current light to the Nth value
  LightList& set(int n) {
    if(n >= 0 && n < numLights)
      currLight = n;
    return *this;
  }
  
  // reset the current light to the first one in the list
  LightList& reset(void) {
    if(numLights > 0)
      currLight = 0;
    else
      currLight = (-1);
    return *this;
  }
  
  // move the current light to the next in the list.  If the end of the
  // list is passed, the current light is undefined (-1).
  LightList& next(void) {
    if(currLight >= 0) {
      currLight++;
      if(currLight >= numLights)
        currLight = (-1);
    }
    return *this;
  }

};

#endif
