/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ReadEDM.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 95/03/24 18:51:25 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   for the code to read in an electron density map
 * also, the edm data type
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	ReadEDM.h,v $
 * Revision 1.2  95/03/24  18:51:25  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1995/02/12  07:24:14  dalke
 * Initial revision
 *
 ***************************************************************************/

#ifndef READEDM_H
#define READEDM_H
#include <stddef.h>
#include "Grid.h"

typedef struct edm_t{
   float minx, miny, minz;   // 0, 0, 0
   float maxx, maxy, maxz;   // a, b, c
   float alpha, beta, gamma;
   Grid<float> *grid;
   edm_t(void) {
      grid = NULL;
   }
   ~edm_t(void) {
      if (grid) {
	 delete grid;
      }
   }
};

edm_t *read_edm(char *filename);
#endif
