/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ReadPDB.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 95/03/24 18:51:28 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * General routines to read .pdb files.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	ReadPDB.h,v $
 * Revision 1.2  95/03/24  18:51:28  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1994/09/17  09:11:36  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef READ_PDB_H
#define READ_PDB_H

#include <stdio.h>

#define PDB_RECORD_LENGTH	80

/*	record type defines	*/
#define PDB_REMARK	0
#define PDB_ATOM	1
#define PDB_UNKNOWN	2
#define PDB_END		3
#define PDB_EOF		4


/* read the next record from the specified pdb file, and put the string found
   in the given string pointer (the caller must provide adequate (81 chars)
   buffer space); return the type of record found
*/
int read_pdb_record(FILE *f, char *retStr);


/* Extract the x,y, and z coordinates from the given ATOM record.	*/
void get_pdb_coordinates(char *record, float *x, float *y, float *z,
	float *occup, float *beta);


/* Break a pdb atom record into it's fields.  The user must provide the
   necessary space to store the atom name, residue name, and segment name.
   Character strings will be null-terminated.  Returns the atom serial number. */
int get_pdb_fields(char *record, char *name, char *resname, char *segname,
   char *resid, float *x, float *y, float *z, float *occup, float *beta);
   
#endif
