/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: TrackerFormsObj.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 95/03/24 18:52:12 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu to control the spatial trackers and 3D pointers (tools).
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	TrackerFormsObj.h,v $
 * Revision 1.2  95/03/24  18:52:12  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1995/02/26  22:22:57  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef TRACKERFORMSOBJ_H
#define TRACKERFORMSOBJ_H

#include "FormsObj.h"


class TrackerFormsObj : public FormsObj {

private:
  // determine which editing mode has been selected by checking if the given
  // FL_OBJECT is one of the editing-changing buttons.  Return index if
  // the object is a mode, or (-1) otherwise.
  int find_editing_mode(FL_OBJECT *);

  // set the tracker/tool editing mode to the given value
  void set_editing_mode(int);

  // fill the available tracker browser
  void reset_avail_tracker_browser(void);

  // fill the running tracker browser
  void reset_running_tracker_browser(void);

  // fill the tool browser
  void reset_tool_browser(void);

  // select the Nth tool
  void select_tool(int);

protected:
  // check if the given forms pointer is one for this menu, and generate
  // a command if necessary.  Return 'TRUE' if the pointer is for an object
  // in this menu.
  virtual int check(FL_OBJECT *);

  // do form-specific acting on commands
  virtual int forms_act_on_command(int, Command *, int);

public:
  // class constructor and destructor
  TrackerFormsObj(UIList *, CommandQueue *, int, int, int * = NULL);

  //
  // virtual routines for UI init/display
  //
  
  // initialize the user interface
  virtual void init(void);
  
  // reset the user interface (forces update of all info displays)
  virtual void reset(void);

};

#endif
