/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: UIText2.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.6 $	$Date: 1995/03/28 03:47:56 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * This is the User Interface for text commands.  It reads characters from
 * the console, and executes the commands.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: UIText2.C,v $
 * Revision 1.6  1995/03/28  03:47:56  billh
 * now includes UIList.h properly.
 *
 * Revision 1.5  95/03/24  18:52:29  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.4  1995/03/04  05:14:26  billh
 * Added geomtry labelling commands.
 *
 * Revision 1.3  95/02/12  07:19:32  dalke
 * let "top" be a valid mol specifier
 * 
 * Revision 1.2  1994/12/06  08:22:44  billh
 * Added color commands.
 *
 * Revision 1.1  94/11/24  07:26:41  dalke
 * Initial revision
 * 
 *
 *  Diverged from Revision 1.23 of UIText.C 
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /tmp_mnt/Home/h2/billh/projects/vmd/src/RCS/UIText2.C,v 1.6 1995/03/28 03:47:56 billh Exp $";
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#if defined(ARCH_IRIX4) || defined(ARCH_IRIX5) || defined(ARCH_IRIX6)
#include <bstring.h>
#endif
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <ctype.h>
#include <fcntl.h>
#include "UIList.h"
#include "UIText.h"
#include "UIVR.h"
#include "CommandQueue.h"
#include "CmdAnimate.h"
#include "CmdColor.h"
#include "CmdLabel.h"
#include "CmdMol.h"
#include "CmdTracker.h"
#include "CmdTool.h"
#include "GrabTool.h"
#include "LightList.h"
#include "ColorList.h"
#include "Stage.h"
#include "Axes.h"
#include "Inform.h"
#include "utilities.h"
#include "config.h"
#include "TrackerList.h"
#include "MoleculeList.h"

#ifdef VMDFORMS
#include "CmdMenu.h"
#endif

#ifdef VMDREMOTE
#include "CmdRemote.h"
#endif

#ifdef VMDEXTERNAL
#include "CmdExternal.h"
#endif

//////////////////////
// functions which evaluate the text to turn it into a Cmd ##############
//////////////////////

// prints an error message and returns FALSE when the tracker is
// outside the allowed range.  Otherwise, it returns TRUE
int UIText::valid_tracker_range(int tracker, int maxtracker)
{
    if (tracker<0 || tracker>=maxtracker) {
      if (maxtracker==0) {
        msgErr << "There are no trackers running." << sendmsg;
      } else if (maxtracker==1) {
        msgErr << "There is only one tracker running." << sendmsg;
      } else {
        msgErr << "The running trackers number from 1 to "<< maxtracker
                << "." << sendmsg;
      }
      return FALSE;
    }
  return TRUE;  // all a-okay
}

// returns the value for texterr -- FALSE means all okay
int UIText::texteval_tracker(int argc, char *argv[])
{
  // so the first word [0] is "tracker".  Here are the options
  // tracker list         -- list running trackers
  // tracker list avail   -- list available trackers
  // tracker start number [on remotemachine] -- start avail tracker "number"
  //                            possible remotely
  // tracker pause number [on remotemachine] -- pause tracker "number"
  // tracker location number sensor -- print the current location of 
  //                            a sensor on the tracker "number"


  if (argc < 2 || argc > 5)  // 2 and 5 are obviously out of bounds, now
    return TRUE;
    
  // "tracker list" and "tracker list avail"
  if (!strupncmp(argv[1], "list", CMDLEN)) {  // ############
    if (argc == 2) { // tracker list
      addcommand(new CmdTrackerList());
      return FALSE;
    } else if ( !strupncmp(argv[2], "avail", CMDLEN)) {
      addcommand(new CmdTrackerListAvail());
      return FALSE;
    }
    return TRUE;
  } // end of "tracker list [avail]
  
  // tracker start number [on remotemachine]  #################
  if (!strupncmp(argv[1], "start", CMDLEN)) {
    if (argc !=3 && !(argc == 5 && strupncmp(argv[3], "on", CMDLEN)))
      return TRUE;
    int i = atoi(argv[2])-1;// note that the first tracker is number 1 !
    int n = trackerList -> num_avail();
    if (i<0 || i >= n ) {
      if (n==0) {
        msgErr << "  There are no trackers available.  There is no\n";
        msgErr << "way to fix this without reprogramming." << sendmsg;
        return FALSE;
      }
      if (n==1) {
        msgErr << "There is only one available tracker." << sendmsg;
        return FALSE;
      }
      msgErr << "The available trackers range from 1 to "<< n <<"." <<sendmsg;
    return FALSE;
    }  // end of out of bounds error messages
    
    // send a start message to the appropriate tracker
    if (argc == 3)
      addcommand(new CmdTrackerStart(i, NULL));
    else
      addcommand(new CmdTrackerStart(i, argv[4]));
    return FALSE;
  } // end of "tracker start number [on remotemachine]"
  
  // tracker location number sensor  ######################
  if (!strupncmp(argv[1], "location", CMDLEN)) {
    if (argc != 4) {
      msgErr << "tracker location 'tracker number' 'sensor number'" << sendmsg;
      return FALSE;
    }
    int i = atoi(argv[2]) - 1; // offset by one
    int n = trackerList -> num();
    if (!valid_tracker_range(i,n)) {
      return FALSE;  // already printed error message
    }
    int s = atoi(argv[3]) - 1;  // offset by one
    int ns = trackerList -> tracker(i) -> numSensors();
    if (s<0 || s >= ns) {
      if (ns == 1) {
        msgErr << "There is only one sensor on tracker " << n <<"."<<sendmsg;
      } else {
        msgErr << "The sensors on tracker " << n << " number from 1 to " <<
                  ns << "." << sendmsg;
      }
      return FALSE;
    }
    addcommand(new CmdTrackerLoc(i, s));
    return FALSE;
  }  // end of "tracker location 'tracker num' 'sensor num' "
  
  // tracker pause 'tracker num'  ###########
  if (!strupncmp(argv[1], "pause", CMDLEN)) {
    if (argc != 3) {
      msgErr << "tracker pause 'tracker number'" << sendmsg;
      return FALSE;
    }
    int i = atoi(argv[2]) - 1; // offset by one
    int n = trackerList -> num();
    if (!valid_tracker_range(i,n)) {
      return FALSE;       // already printed error message
    }
    addcommand(new CmdTrackerPause(i));
    return FALSE;
  }
  // tracker unpause 'tracker num'  ###########
  if (!strupncmp(argv[1], "unpause", CMDLEN)) {
    if (argc != 3) {
      msgErr << "tracker unpause 'tracker number'" << sendmsg;
      return FALSE;
    }
    int i = atoi(argv[2]) - 1; // offset by one
    int n = trackerList -> num();
    if (!valid_tracker_range(i,n)) {
      return FALSE;       // already printed error message
    }
    addcommand(new CmdTrackerUnpause(i));
    return FALSE;
  }
  return TRUE;  // oh-no Mr. Billh!  Here comes Mr* Sluggo = new BadGuy()
} 


/////////////////
// evaluate text commands for molecule
/////////////////

// return T if there was an error
int UIText::texteval_molecule(int argc, char *argv[])  {

  // list the molecules?
  if(argc < 4 && !strupncmp(argv[1], "list", CMDLEN)) {
    if(argc == 2)
      addcommand(new CmdMolList((-1), id()));
    else
      addcommand(new CmdMolList(atoi(argv[2]),id()));

  } else if(argc > 1 && !strupncmp(argv[1],"selection",CMDLEN)) {
    int sl, i;
    char *molstr = NULL;
    for(sl = 0, i=2; i < argc; i++)  sl += strlen(argv[i]);
    if(sl) {
      molstr = new char[sl + 8 + argc];	// extra buffer added
      molstr[0] = '\0';
      for(i=2; i < argc; i++) {
        strcat(molstr, argv[i]);  strcat(molstr," ");
      }
    }
    addcommand(new CmdMolSelect(molstr, id()));
    if(molstr)  delete [] molstr;

  } else if(argc > 1 && (!strupncmp(argv[1],"representation",CMDLEN) ||
  	!strupncmp(argv[1],"rep",CMDLEN)) ) {
    int sl, i;
    char *molstr = NULL;
    for(sl = 0, i=2; i < argc; i++)  sl += strlen(argv[i]);
    if(sl) {
      molstr = new char[sl + 8 + argc];	// extra buffer added
      molstr[0] = '\0';
      for(i=2; i < argc; i++) {
        strcat(molstr, argv[i]);  strcat(molstr," ");
      }
    }
    addcommand(new CmdMolRep(molstr, id()));
    if(molstr)  delete [] molstr;

  } else if(argc > 1 && !strupncmp(argv[1],"color",CMDLEN)) {
    int sl, i;
    char *molstr = NULL;
    for(sl = 0, i=2; i < argc; i++)  sl += strlen(argv[i]);
    if(sl) {
      molstr = new char[sl + 8 + argc];	// extra buffer added
      molstr[0] = '\0';
      for(i=2; i < argc; i++) {
        strcat(molstr, argv[i]);  strcat(molstr," ");
      }
    }
    addcommand(new CmdMolColor(molstr, id()));
    if(molstr)  delete [] molstr;

  } else if(argc > 4 && (!strupncmp(argv[1],"modcolor",CMDLEN) ||
  	!strupncmp(argv[1],"modstyle",CMDLEN) ||
	!strupncmp(argv[1],"modselect",CMDLEN)) ) {
    int sl, i;
    char *molstr = NULL;
    for(sl = 0, i=4; i < argc; i++)  sl += strlen(argv[i]);
    molstr = new char[sl + 8 + argc];	// extra buffer added
    molstr[0] = '\0';
    for(i=4; i < argc; i++) {
      strcat(molstr, argv[i]);  strcat(molstr," ");
    }
    if (!strupncmp(argv[2],"top", 4)) {  // "top" == -1
       argv[2][0] = '-';
       argv[2][1] = '1';
       argv[2][2] = 0;
    }
    if(!strupncmp(argv[1],"modcolor",CMDLEN))
      addcommand(new CmdMolChangeRepItem(atoi(argv[2]), atoi(argv[3]),
      		 CmdMolChangeRepItem::COLOR, molstr, id()));
    else if(!strupncmp(argv[1],"modstyle",CMDLEN))
      addcommand(new CmdMolChangeRepItem(atoi(argv[2]), atoi(argv[3]),
      		 CmdMolChangeRepItem::REP, molstr, id()));
    else if(!strupncmp(argv[1],"modselect",CMDLEN))
      addcommand(new CmdMolChangeRepItem(atoi(argv[2]), atoi(argv[3]),
      		 CmdMolChangeRepItem::SEL, molstr, id()));
    if(molstr)  delete [] molstr;

  } else if(argc < 4 && argc > 1 && !strupncmp(argv[1],"addrep",CMDLEN)) {
    int mn = (-1);
    if(argc == 3)
      mn = atoi(argv[2]);
    addcommand(new CmdMolAddRep(mn, id()));

  } else if(argc == 4 && !strupncmp(argv[1],"delrep",CMDLEN)) {
    addcommand(new CmdMolDeleteRep(atoi(argv[2]), atoi(argv[3]), id()));

  } else if(argc == 4 && !strupncmp(argv[1],"modrep",CMDLEN)) {
    addcommand(new CmdMolChangeRep(atoi(argv[2]), atoi(argv[3]), id()));

  } else if(argc == 3 && !strupncmp(argv[1],"delete",CMDLEN)) {
    addcommand(new CmdMolDelete(atoi(argv[2]), id()));

  } else if(argc == 3 && (!strupncmp(argv[1],"active",CMDLEN) ||
  			!strupncmp(argv[1],"inactive",CMDLEN))) {
    addcommand(new CmdMolActive(atoi(argv[2]),
    	(strupncmp(argv[1],"active",CMDLEN) == 0), id()));

  } else if(argc == 3 && (!strupncmp(argv[1],"on",CMDLEN) ||
  			!strupncmp(argv[1],"off",CMDLEN))) {
    addcommand(new CmdMolOn(atoi(argv[2]),
    	(strupncmp(argv[1],"on",CMDLEN) == 0), id()));

  } else if(argc == 3 && (!strupncmp(argv[1],"fix",CMDLEN) ||
  			!strupncmp(argv[1],"free",CMDLEN))) {
    addcommand(new CmdMolFix(atoi(argv[2]),
    	(strupncmp(argv[1],"fix",CMDLEN) == 0), id()));

  } else if(argc == 3 && !strupncmp(argv[1],"top",CMDLEN)) {
    addcommand(new CmdMolTop(atoi(argv[2]), id()));

  } else
    return TRUE;
  
  return FALSE;
}


/////////////////
// evaluate text commands for remote connection setup
/////////////////

// return T if there was an error
int UIText::texteval_remote(int argc, char *argv[])  {

#ifdef VMDREMOTE
  if(argc == 2) {
    if(!strupncmp(argv[1], "cancel", CMDLEN))
      addcommand(new CmdRemoteCancel(id()));
    else if(!strupncmp(argv[1], "list", CMDLEN))
      addcommand(new CmdRemoteList(CmdRemoteList::ALL, id()));
    else if(!strupncmp(argv[1], "run", CMDLEN))
      addcommand(new CmdRemoteRun(id()));
    else
      return TRUE;
  } else if(argc == 3) {
    if(!strupncmp(argv[1], "list", CMDLEN)) {
      if(!strupncmp(argv[2], "all", CMDLEN))
        addcommand(new CmdRemoteList(CmdRemoteList::ALL, id()));
      else if(!strupncmp(argv[2], "jobs", CMDLEN))
        addcommand(new CmdRemoteList(CmdRemoteList::JOBS, id()));
      else if(!strupncmp(argv[2], "apps", CMDLEN))
        addcommand(new CmdRemoteList(CmdRemoteList::APPS, id()));
      else if(!strupncmp(argv[2], "parameters", CMDLEN))
        addcommand(new CmdRemoteList(CmdRemoteList::PARAMS, id()));
      else
        return TRUE;
    } else if(!strupncmp(argv[1], "initialize", CMDLEN)) {
      addcommand(new CmdRemoteInit(argv[2], NULL, id()));
    } else if(!strupncmp(argv[1], "new", CMDLEN)) {
      addcommand(new CmdRemoteNew(atoi(argv[2]), id()));
    } else if(!strupncmp(argv[1], "attach", CMDLEN)) {
      addcommand(new CmdRemoteAttach(atoi(argv[2]), id()));
    } else if(!strupncmp(argv[1], "readoptions", CMDLEN)) {
      addcommand(new CmdRemoteReadopt(argv[2], id()));
    } else if(!strupncmp(argv[1], "writeoptions", CMDLEN)) {
      addcommand(new CmdRemoteWriteopt(argv[2], id()));
    } else
      return TRUE;
  } else if(argc == 4) {
    if(!strupncmp(argv[1], "initialize", CMDLEN)) {
      addcommand(new CmdRemoteInit(argv[2], argv[3], id()));
    } else if(!strupncmp(argv[1], "setoption", CMDLEN)) {
      addcommand(new CmdRemoteSetopt(argv[2], argv[3], id()));
    } else
      return TRUE;
  } else
    return TRUE;
    
  // if here, command was found
  return FALSE;

#else
  if(argc || argv);		// keep compiler happy
  return TRUE;			// remote not available ... signal error
#endif

}


/////////////////
// evaluate text commands for working with menus
/////////////////

// return T if there was an error
int UIText::texteval_menu(int argc, char *argv[])  {

#ifdef VMDFORMS
  // menu commands
  UIObject *ui = uiList->item(argv[1]);
  if(ui && ui->is_menu()) {		// menu name is valid
    if(argc == 3) {
      if(!strupncmp(argv[2],"on",CMDLEN))
        addcommand(new CmdMenuShow(ui->id(), TRUE, id()));
      else if (!strupncmp(argv[2],"off",CMDLEN))
        addcommand(new CmdMenuShow(ui->id(), FALSE, id()));
      else if (!strupncmp(argv[2],"loc",CMDLEN))
        addcommand(new CmdMenuLoc(ui->id(), id()));
      else
        return TRUE;
    } else if(argc == 5) {
      if (!strupncmp(argv[2],"move",CMDLEN))
        addcommand(new CmdMenuMove(ui->id(),atoi(argv[3]),
	  	atoi(argv[4]),id()));
      else
	return TRUE;
    } else
      return TRUE;
  } else
    return TRUE;
    
  // if here, command was found
  return FALSE;

#else
  if(argc || argv);		// keep compiler happy
  return TRUE;			// menus not available ... signal error
#endif

}

/////////////////
// evaluate text commands for working with the Tools
/////////////////
// I do very little error in this evaluation, trusting that the
// CmdTool* will not accept or ignore values <=0
int UIText::texteval_tool(int argc, char *argv[])
{     
   if (argc <= 2)
     return TRUE;
   int toolid = atoi(argv[1]) - 1;  // text input starts from 1 to n
   // tool number info |  print out the info
   // tool number set  |    about a tool
   if (!strupncmp(argv[2], "info", CMDLEN) || 
       (!strupncmp(argv[2], "set", CMDLEN) && argc == 3)) {
     addcommand(new CmdToolInfo(toolid, id()));
     return FALSE;
   }
   // tool number push newtool
   if (!strupncmp(argv[2], "push", CMDLEN)) {
     if (argc != 4)
       return TRUE;
     if (!strupncmp(argv[3], "grabber", CMDLEN)) {
       addcommand(new CmdToolPush(toolid, new GrabTool("grabber", scene)));
       return FALSE;
     }
     return TRUE;
   }
   // tool number pop
   if (!strupncmp(argv[2], "pop", CMDLEN)) {
     if (argc != 3)
       return TRUE;
     addcommand(new CmdToolPop(toolid));
     return FALSE;
   }
   
   // tool number replace newtool  -- a pop then a push
   if (!strupncmp(argv[2], "replace", CMDLEN)) {
     if (argc != 4)
       return TRUE;
     if (!strupncmp(argv[3], "grabber", CMDLEN)) {
       addcommand(new CmdToolReplace(toolid, new GrabTool("grabber", scene)));
       return FALSE;
     }
     return TRUE;
   }
   
   // tool number [{set,add,mult} [size newsize] [length newlength]
   //               {set,add} [offset x y z]  [detail newdetail]]+
   if (  !strupncmp(argv[2], "set", CMDLEN)||!strupncmp(argv[2], "add", CMDLEN)
       ||!strupncmp(argv[2], "mult", CMDLEN) ) {
         int pos = 2;
         int problems = FALSE;
         // for each of the inputs, toss a Command on the commandQueue
         while (pos < argc) {
           if (!strupncmp(argv[pos], "set",CMDLEN)) {
             if (!strupncmp(argv[pos+1], "scale",CMDLEN)) {
               addcommand(new CmdToolSetSize(toolid, 
                    atof(argv[pos+2]), 0.0, 0, id()));
               pos += 3;
               continue;
             }
             if (!strupncmp(argv[pos+1], "length", CMDLEN)) {
               addcommand(new CmdToolSetSize(toolid,
                    0.0, atof(argv[pos+2]), 0, id()));
                pos += 3;
                continue;
             }
             if (!strupncmp(argv[pos+1], "detail", CMDLEN)) {
               addcommand(new CmdToolSetSize(toolid,
                    0.0, 0.0, atoi(argv[pos+2]), id()));
                pos += 3;
                continue;
             }
             if (!strupncmp(argv[pos+1], "offset", CMDLEN)) {
               if (pos + 5 <= argc) {
                   addcommand(new CmdToolSetOffset(toolid,
                     atof(argv[pos+2]), atof(argv[pos+3]), atof(argv[pos+4]),
                     id() ) );
                   pos += 5;
                   continue;
               } else {
                  pos = argc;
                  problems = TRUE;
                  continue;
               }
             }
            pos = argc;
            problems = TRUE;
            continue;
          }
          if (!strupncmp(argv[pos], "add",CMDLEN)) {
            if (!strupncmp(argv[pos+1], "scale",CMDLEN)) {
              addcommand(new CmdToolAddSize(toolid, 
                   atof(argv[pos+2]), 0.0, 0, id()));
              pos += 3;
              continue;
            }
            if (!strupncmp(argv[pos+1], "length", CMDLEN)) {
              addcommand(new CmdToolAddSize(toolid,
                   0.0, atof(argv[pos+2]), 0, id()));
               pos += 3;
               continue;
            }
            if (!strupncmp(argv[pos+1], "detail", CMDLEN)) {
              addcommand(new CmdToolAddSize(toolid,
                   0.0, 0.0, atoi(argv[pos+2]), id()));
               pos += 3;
               continue;
            }
            if (!strupncmp(argv[pos+1], "offset", CMDLEN)) {
              if (pos + 5 <= argc) {
                  addcommand(new CmdToolAddOffset(toolid,
                    atof(argv[pos+2]), atof(argv[pos+3]), atof(argv[pos+4]),
                    id() ) );
                  pos += 5;
                  continue;
              } else {
                 pos = argc;
                 problems = TRUE;
                 continue;
              }
            }
            pos = argc;
            problems = TRUE;
            continue;
          }
          pos = argc;
          problems = TRUE;
          continue;
        }
        return problems;
      }
 return TRUE;
}


/////////////////
// evaluate text commands for editing colors
/////////////////

int UIText::texteval_color(int argc, char *argv[])  {

  if(!strupncmp(argv[1], "change", CMDLEN)) {
    if(argc == 6) {
      addcommand(new CmdColorChange(argv[2], atof(argv[3]), atof(argv[4]),
      			atof(argv[5]), id()));
    } else if(argc == 4) {
      addcommand(new CmdColorChange(argv[2], argv[3], id()));
    } else if(argc == 3) {
      addcommand(new CmdColorChange(argv[2], id()));
    } else {
      return TRUE;
    }

  } else if(!strupncmp(argv[1], "scale", CMDLEN)) {
    if(argc == 4) {
      if(!strupncmp(argv[2], "method", CMDLEN)) {
        int i;
        for(i=0; i < ColorList::SCALE_TOTAL; i++) {
	  if(!strupncmp(argv[3], colorScaleMethod[i], CMDLEN)) {
	    addcommand(new CmdColorScaleMethod(i, id()));
	    break;
	  }
	}
	if(i == ColorList::SCALE_TOTAL)
	  return TRUE;
      } else if(!strupncmp(argv[2], "midpoint", CMDLEN)) {
        addcommand(new CmdColorScaleMidpoint(atof(argv[3]), id()));
      } else if(!strupncmp(argv[2], "min", CMDLEN)) {
        addcommand(new CmdColorScaleMin(atof(argv[3]), id()));
      } else if(!strupncmp(argv[2], "min", CMDLEN)) {
        addcommand(new CmdColorScaleMax(atof(argv[3]), id()));
      } else
        return TRUE;
    } else
      return TRUE;
    
  } else if(argc == 3 || argc == 4) {
    char *clr = (argc == 3 ? NULL : argv[3]);
    addcommand(new CmdColorName(argv[1], argv[2], clr, id()));

  } else
    return TRUE;
    
  // if here, everything worked out ok
  return FALSE;
}


/////////////////
// evaluate text commands for labelling objects
/////////////////

int UIText::texteval_label(int argc, char *argv[])  {

  if(!strupncmp(argv[1], "add", CMDLEN)) {
    if(argc > 3)
      addcommand(new CmdLabelAdd(argv[2], argc-3, argv+3, id()));
    else
      return TRUE;

  } else if(!strupncmp(argv[1], "list", CMDLEN)) {
    if(argc == 3)
      addcommand(new CmdLabelList(argv[2], id()));
    else
      return TRUE;

  } else if(!strupncmp(argv[1], "show", CMDLEN) ||
	    !strupncmp(argv[1], "hide", CMDLEN)) {
    int item;
    if(argc == 3 || (argc == 4 && !strupncmp(argv[3], "all", CMDLEN)))
      item = (-1);
    else if(argc == 4)
      item = atoi(argv[3]);
    else
      return TRUE;
    
    addcommand(new CmdLabelShow(argv[2],
		 !strupncmp(argv[1], "show", CMDLEN), item, id()));

  } else if(!strupncmp(argv[1], "delete", CMDLEN)) {
    int item;
    if(argc == 3 || (argc == 4 && !strupncmp(argv[3], "all", CMDLEN)))
      item = (-1);
    else if(argc == 4)
      item = atoi(argv[3]);
    else
      return TRUE;

    addcommand(new CmdLabelDelete(argv[2], item, id()));

  } else if(!strupncmp(argv[1], "graph", CMDLEN) && argc > 3) {
    int item = atoi(argv[3]);
    char graphcmd[128];
    *graphcmd = '\0';
    for(int i=4; i < argc; i++) {
      strcat(graphcmd, argv[i]);
      strcat(graphcmd, " ");
    }
    addcommand(new CmdLabelGraph(argv[2], item, graphcmd, id()));

  } else
    return TRUE;

  return FALSE;
}

      
/////////////////
// evaluate text commands for animation
/////////////////

int UIText::texteval_anim(int argc, char *argv[])  {

  if(argc == 2) {
    Animation::AnimDir newDir;
    if(!strupncmp(argv[1], "reverse", CMDLEN) ||
    	!strupncmp(argv[1], "rev", CMDLEN))
      newDir = Animation::REVERSE;
    else if(!strupncmp(argv[1], "forward", CMDLEN) ||
    	!strupncmp(argv[1], "for", CMDLEN))
      newDir = Animation::FORWARD;
    else if(!strupncmp(argv[1], "prev", CMDLEN))
      newDir = Animation::REVERSE1;
    else if(!strupncmp(argv[1], "next", CMDLEN))
      newDir = Animation::FORWARD1;
    else if(!strupncmp(argv[1], "pause", CMDLEN))
      newDir = Animation::FORWARD1;
    else
      return TRUE;		// error
    addcommand(new CmdAnimDir(newDir, id()));
  } else if(argc == 3) {
    if(!strupncmp(argv[1], "skip", CMDLEN))
      addcommand(new CmdAnimSkip(atoi(argv[2]), id()));
    else if(!strupncmp(argv[1], "delete", CMDLEN)) {
      if(!strupncmp(argv[2], "all", CMDLEN))
        addcommand(new CmdAnimDelete(-1, -1, -1, -1, id()));
      else
        return TRUE;
    } else if(!strupncmp(argv[1], "speed", CMDLEN))
      addcommand(new CmdAnimSpeed(atof(argv[2]), id()));
    else if(!strupncmp(argv[1], "style", CMDLEN)) {
      int newStyle = Animation::ONCE;
      Animation::AnimStyle enumVal;
      while(newStyle < Animation::TOTAL_STYLES) {
        if(!strupncmp(argv[2], animationStyleName[newStyle], CMDLEN))
	  break;
	newStyle++;
      }
      if(newStyle == Animation::ONCE)
        enumVal = Animation::ONCE;
      else if(newStyle == Animation::ROCK)
        enumVal = Animation::ROCK;
      else if(newStyle == Animation::LOOP)
        enumVal = Animation::LOOP;
      else
        return TRUE;		// error, unknown style
      addcommand(new CmdAnimStyle(enumVal, id()));
    } else if(!strupncmp(argv[1], "goto", CMDLEN)) {
      int newframe;
      if(!strupncmp(argv[2], "start", CMDLEN))
        newframe = SET_FRAME_START;
      else if(!strupncmp(argv[2], "end", CMDLEN))
        newframe = SET_FRAME_END;
      else if(isdigit(argv[2][0]))
        newframe = atoi(argv[2]);
      else
        return TRUE;		// error, bad frame goto command
      addcommand(new CmdAnimJump(newframe, id()));
    } else
      return TRUE;
  } else if(argc >= 4) {
    int bf = (-1), ef = (-1), fs = (-1), mid = (-1);
    int fileType = CoorFileData::UNKNOWN;
    char *fileName = NULL;
    int do_action = (-1);
    int currarg = 1;

    // find out what to do first
    if(!strupncmp(argv[currarg], "read", CMDLEN)) {
      do_action = 0;
    } else if(!strupncmp(argv[currarg], "write", CMDLEN)) {
      do_action = 1;
    } else if(!strupncmp(argv[currarg], "delete", CMDLEN)) {
      do_action = 2;
    } else
      return TRUE;
    currarg++;

    // if reading or writing, get file type and name
    if(do_action == 0 || do_action == 1) {
      for(int i=0; i < CoorFileData::COORTYPES; i++)
        if(!strupncmp(argv[currarg], CoorFileSuffix[i], CMDLEN))
	  fileType = i;
      if(fileType == CoorFileData::UNKNOWN) {
        msgErr << "Unknown coordinate file type " << argv[currarg];
	msgErr << sendmsg;
	return TRUE;
      }
      currarg++;
      fileName = argv[currarg++];
    }
    
    // find if any beg, end, or skip specifiers
    while(currarg < argc) {
      if(currarg < (argc - 1)) {
        if(!strupncmp(argv[currarg], "beg", CMDLEN)) {
	  bf = atoi(argv[currarg+1]);
	  currarg += 2;
	} else if(!strupncmp(argv[currarg], "end", CMDLEN)) {
	  ef = atoi(argv[currarg+1]);
	  currarg += 2;
	} else if(!strupncmp(argv[currarg], "skip", CMDLEN)) {
	  fs = atoi(argv[currarg+1]);
	  currarg += 2;
	} else if(do_action == 2 && argc == 4 && currarg == 2 &&
			!strupncmp(argv[currarg], "all", CMDLEN)) {
	  mid = atoi(argv[currarg+1]);
	  bf = ef = fs = (-1);
	  currarg += 2;
	} else
	  return TRUE;
      } else {
        // only one item left; it must be the molecule id
	mid = atoi(argv[currarg++]);
      }
    }
    
    // do action now
    if(do_action == 0)
      addcommand(new CmdAnimReadFile(mid,fileName,fileType,bf,ef,fs,id()));
    else if(do_action == 1)
      addcommand(new CmdAnimWriteFile(mid,fileName,fileType,bf,ef,fs,id()));
    else if(do_action == 2)
      addcommand(new CmdAnimDelete(mid,bf,ef,fs,id()));
    else
      return TRUE;
  } else
    return TRUE;
    
  // if here, everything worked out ok
  return FALSE;
}


/////////////////
// evaluate text commands for external connection
/////////////////

int UIText::texteval_external(int argc, char *argv[])  {

#ifdef VMDEXTERNAL
  if(argc == 2) {
    if (!strupncmp(argv[1], "on", CMDLEN) ||
	!strupncmp(argv[1], "begin", CMDLEN) ||
	!strupncmp(argv[1], "start", CMDLEN)) {
      addcommand(new CmdExternalStart(id()));
    } else if (!strupncmp(argv[1], "off", CMDLEN) ||
	       !strupncmp(argv[1], "end", CMDLEN) ||
	       !strupncmp(argv[1], "stop", CMDLEN)) {
      addcommand(new CmdExternalEnd(id()));
    } else {
      return TRUE;
    }
  } else
    return TRUE;
    
  // if here, everything worked out ok
  return FALSE;

#else
  if(argc || argv);		// keep compiler happy
  return TRUE;			// external not available ... signal error
#endif

}
