/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

// UIVR
#ifndef UIVR_H
#define UIVR_H

#include "UIObject.h"
#include "TrackerList.h"
#include "Buttons.h"
#include "VRegionList.h"

// extern UIVR *uiVR;  declared at the end of this file
extern TrackerList *trackerList;

class UIVR : public UIObject {
public:
  Buttons *kbdButtons1;  // the different types of input buttons
  Buttons *kbdButtons2;
  Buttons *kbdButtons3;
  Buttons *caveButtons;
  
public:
  VRegionList *vregions;     // list of the different vregions
  ResizeArray<ToolControl *> tools; // list of the different Tools  
  
public:
  UIVR(UIList *, CommandQueue *);  // constructor

  void help(void);  // print out help
  
  // update the display due to a command being executed.  Return whether
  // any action was taken on this command.
  virtual int act_on_command(int, Command *, int);

  // check for an event, and queue it if found.  Return TRUE if an event
  // was generated.
  virtual int check_event(void);

};

extern UIVR *uiVR;

#endif // UIVR_H
