/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: VRegion.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 95/03/24 18:52:40 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Code for the VRegion.
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	VRegion.C,v $
 * Revision 1.4  95/03/24  18:52:40  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.3  1994/11/09  05:04:37  billh
 * Moved VRegionList to a separate file.
 *
 * Revision 1.2  1994/09/26  18:54:30  dalke
 * Added name at the top of the button
 *
 * Revision 1.1  1994/09/26  07:15:16  dalke
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /private/auto143000131/vmdsrc/vmd/billh/src/RCS/VRegion.C,v 1.4 95/03/24 18:52:40 billh Exp $";
#endif


#include "VRegion.h"
#include "DispCmds.h"
#include "ToolControl.h"

///////////////////////////////  constructor
// given the initial coordinates (in absolute positions, not
//  as a position and set of offsets)
// set up the different vectors used elsewhere in the class
VRegion::VRegion(float *c1, float *c2, float *c3, float *c4, char *newname,
                 Scene *sc, int memsize, int is_everywhere)
 : Displayable3D(MULT, newname, sc, memsize)
{
  name = stringdup(newname);
  memcpy(corner, c2, 3*sizeof(float));  // save the corner
  subtract(v1, c1, c2);  l1 = norm(v1);
  subtract(v2, c3, c2);  l2 = norm(v2);
  subtract(v3, c4, c2);  l3 = norm(v3);
  memcpy(uv1, v1, 3*sizeof(float)); normalize(uv1);  // create the unit vects
  memcpy(uv2, v2, 3*sizeof(float)); normalize(uv2);  // used to check if a
  memcpy(uv3, v3, 3*sizeof(float)); normalize(uv3);  // coord is inside
  laststate = OUTSIDE;
  uses_all_space = is_everywhere;  // range of validity
  
  // set up the drawing stuff
  rot_off();
  scale_off();
  glob_trans_off();
  cent_trans_off();
  redraw_list(OUTSIDE);
}

///////////////////////////////  destructor
VRegion::~VRegion(void) {
  delete [] name;
}


//////////////////////////////  member functions

// just draw a cube
void VRegion::redraw_list(int state) {
  reset_disp_list();  // clear out everything
  if (uses_all_space)  // I ain't going to draw everywhere
    return;
  // draw the bottom
  float corner1[3], corner2[3], corner3[3];
  float corner4[3], corner5[3], corner6[3];
  float corner7[3];

  add(corner1, corner , v1);  // find the location of the other corners
  add(corner2, corner , v2);
  add(corner3, corner , v3);
  add(corner4, corner1, v2);
  add(corner5, corner1, v3);
  add(corner6, corner2, v3);
  add(corner7, corner6, v1);
   // draw the bottom
  DispCmdColorIndex newcol(REGGREY);
  newcol.put(this);
  DispCmdSquare square(corner1, corner, corner2); 
  square.put(this); 
   // and top
  newcol.putdata(state == INSIDE ? REGRED : REGPINK, this);
  square.putdata(corner5, corner7, corner6, this);

   // and sides
  newcol.putdata(REGYELLOW, this);
   // perp to x
  square.putdata(corner4, corner7, corner5, this);
  square.putdata(corner2, corner, corner3, this);

  // perp to y
  newcol.putdata(REGBLUE, this);
  square.putdata(corner6, corner7, corner4, this);
  square.putdata(corner3, corner, corner1, this);
  
  // and add the text
  float text_vector[3];
  add(text_vector, corner, v3);
  DispCmdTextPos txtpos(text_vector);
  txtpos.put(this);
  DispCmdText title(name); // name comes from being a Displayable
  title.put(this);
}

// A tool wants to see if the point of interest is inside the region
int VRegion::check_event(float *pos, ToolControl *toolctrl)
{
  float delta[3], dp; 
  subtract(delta, pos, corner);
  // we can do a quick check with dot products
  if ( (dp = dot_prod(delta, uv1)) < l1 && dp >= 0 &&
       (dp = dot_prod(delta, uv2)) < l2 && dp >= 0 &&
       (dp = dot_prod(delta, uv3)) < l3 && dp >= 0    ) { // then it is inside
         
     if (laststate == OUTSIDE) { // then I just went inside
       entered(delta, toolctrl);
       inside(delta, toolctrl);
       laststate = INSIDE;
       return TRUE;
     } else {  // then I'm still inside
       inside(delta, toolctrl);
       return TRUE;
     }
  } else {  // then I'm outside
     if (laststate == OUTSIDE) {  // and I was outside, so don't do anything
     } else {
       laststate = OUTSIDE;
       left();  // say goodbye
     }
  }
 return FALSE;  // nothing happened
}

// move to another location - absolute
void VRegion::moveto(float *newpos)
{
  memcpy(corner, newpos, 3*sizeof(float));
  redraw_list(laststate);
}

// move by a delta
void VRegion::moveby(float *delta)
{
  add(corner, corner, delta);
  redraw_list(laststate);
}

// do button stuff
int VRegion::button_event(float *pos, ToolControl *toolctrl)
{
  float delta[3], dp; 
  Buttons *btns;
  int change, i, n;
  
  subtract(delta, pos, corner);
  // we can do a quick check with dot products
  if ( (dp = dot_prod(delta, uv1)) < l1 && dp >= 0 &&
       (dp = dot_prod(delta, uv2)) < l2 && dp >= 0 &&
       (dp = dot_prod(delta, uv3)) < l3 && dp >= 0    ) { // then it is inside

     // for each button that changed, call the button_event function
     if ((btns=toolctrl -> buttons()) != NULL) {
       n = btns->num();
       for (i=0; n>0; i++, n--)
         if ( (change = btns->change(i)) )
           check_button(i, change, delta, toolctrl);
       return TRUE;
     }
  }
  return FALSE;
}

// do something with a button press
void VRegion::check_button(int buttonnum, int change, 
                             float *delta, ToolControl *toolctrl)
{
 if (buttonnum || change || delta || toolctrl)
   ;
}


// note that delta is the distance from the corner, not the position
//   in space!
// called when a Tool just entered the region
void VRegion::entered(float *, ToolControl *) {
  redraw_list(INSIDE);
}


// called just after a Tool leaves the region
void VRegion::left(void) {
  redraw_list(OUTSIDE);
}


// called while a Tool is inside - if it just entered, entered is
//   called first, and then inside is called right after that
void VRegion::inside(float *delta, ToolControl *toolctrl) {
  // do nothing
}
  
