/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: VRegionList.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 95/03/24 18:52:43 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  A VRegionList is a VRegion which contains a list of VRegions.  The
 * idea is that a VRegion is list a button, or slider, and a VRegionList
 * is a menu of buttons, sliders, etc.  Since all the items are inside
 * the list, the search to find if the coordinates are outside is faster.
 * In addition, moving the list also moves the children in the list.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	VRegionList.C,v $
 * Revision 1.2  95/03/24  18:52:43  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1994/11/09  05:00:50  billh
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /private/auto143000131/vmdsrc/vmd/billh/src/RCS/VRegionList.C,v 1.2 95/03/24 18:52:43 billh Exp $";
#endif

#include "VRegionList.h"
#include "DispCmds.h"
#include "ToolControl.h"

/**************************************************************/
// now for the VRegion which contains a list of VRegions
VRegionList::VRegionList(float *c1, float *c2, float *c3, float *c4,
                         char *name, Scene *sc, int memsize,
                         int is_everywhere)
   : VRegion(c1, c2, c3, c4, name, sc, memsize, is_everywhere)
{  // nope, don't need anything
}

// doesn't do anything; the children list is deleted automatically
VRegionList::~VRegionList(void){
}

// append a region to the list
void VRegionList::append(VRegion *newregion)
{
  children . append(newregion);
}

void VRegionList::redraw_list(int state)
{
  reset_disp_list();
  if (uses_all_space)
    return;
  // just draw the bottom
  DispCmdColorIndex newcol(REGGREY);
  newcol .put(this);
  float corner1[3], corner2[3];
  add(corner1, corner, v1);
  add(corner2, corner, v2);
  DispCmdSquare square(corner1, corner, corner2);
  square .put(this);
  // now cycle through all the children and tell them to redraw_list
  for (children.reset(); children.is_current(); 
           (children.get())->redraw_list(state) )
     ;
}

// I don't do anything, but I do ask all my element to check themselves
int VRegionList::check_event(float *pos, ToolControl *toolctrl)
{
  int flg=0;

// I allow all children to check for tip entry
  for (children.reset(); children.is_current(); flg |= (children.get())->
            check_event(pos, toolctrl) )
      ;
   return flg;
}

//  I should move myself and the children
void VRegionList::moveby(float *delta)
{
  VRegion::moveby(delta);  // move myself
  for (children.reset(); children.is_current(); 
          (children.get()) -> moveby(delta) ) // and children
      ;
}

// I should again (but differently) move
void VRegionList::moveto(float *newpos)
{
  float delta[3];
  subtract(delta, corner, newpos);  // otherwise children move to same place
  VRegion::moveby(newpos);  // move myself
  
  for (children.reset(); children.is_current(); 
             (children.get()) -> moveby(delta) )  // and children
      ;
}

// See which of the children gets a button press -- at most one!
int VRegionList::button_event(float *pos, ToolControl *toolctrl)
{
  for (children.reset(); children.is_current(); )
      if ((children.get()) -> button_event(pos, toolctrl))
          return TRUE; 
}

void VRegionList::check_button(int buttonnum, int change, 
                     float *delta, ToolControl *toolctrl) {
  // ain't no way this should ever be called, so I do nothing
   if (buttonnum || change || delta || toolctrl)
   ;

}
