/**********************************************************/
/***		cave.old.h				***/
/***							***/
/*** Backwards compatibility macros for older code	***/
/***							***/
/**********************************************************/
/*
*	Copyright 1994, Electronic Visualization Laboratory.
*	All rights reserved.
*
*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF EVL.
*	Unless otherwise agreed to in writing by EVL, this code is
*	to be used and accessed only by SIGGRAPH VROOM participants.
*	It is not public domain software.  Call Margaret Rawlings at
*	(312)-996-3002 for details.
*
*/

#ifndef	CAVE_OLD_INCLUDED_ALREADY
#define	CAVE_OLD_INCLUDED_ALREADY

#define  BUTTON1        CAVEBUTTON1
#define  BUTTON2        CAVEBUTTON2
#define  BUTTON3        CAVEBUTTON3

#define cave_near	CAVENear
#define cave_far	CAVEFar

#define cave_init	CAVEInit
#define cave_display	CAVEDisplay
#define cave_exit	CAVEExit
#define	get_head	CAVEGetHead
#define	get_wand	CAVEGetWand  
#define	get_head_orientation	CAVEGetHeadOrientation
#define	get_wand_orientation	CAVEGetWandOrientation
#define wand_orientation	CAVEWandOrientation  
#define head_orientation	CAVEHeadOrientation


/*************************************************************************/
/**                                                                     **/
/**            SOUND MACROS  FOR OLDER VERSIONS                         **/
/**                                                                     **/
/** cave_PlayNote(Note, Veloc, Dur, Chan)                               **/
/** cave_NoteOn(Note, Veloc, Chan)                                      **/
/** cave_NoteOff(Note, Chan)                                            **/
/** cave_PatchChange(Patch)                                             **/
/** cave_PlaceSound(sx, sy, sz)                                         **/
/** cave_setWandVelocity(vol)			                        **/
/** cave_setWandInterval(speed)		                                **/
/** cave_AllNotesOff()		                                        **/
/** cave_PitchBend(channel, pitch)                                      **/
/*************************************************************************/
#define	cave_PlayNote(Note, Veloc, Dur, Chan)	CAVEPlayNote(Note,  Veloc,  Dur,  Chan) 
#define	cave_NoteOn(Note, Veloc, Chan)		CAVENoteOn(Note,  Veloc,  Chan) 
#define	cave_NoteOff(Note, Chan)		CAVENoteOff(Note,  Chan) 
#define	cave_PatchChange(Patch, Channel)	CAVEPatchChange(Patch,  Channel)
#define	cave_PlaceSound(sx, sy, sz,  Chan)	CAVEPlaceSound(sx,  sy,  sz,  Chan) 
#define	cave_LoadSounds(sx)			CAVELoadSounds(sx)
#define	cave_AllNotesOff()			CAVEAllNotesOff()
#define	cave_PitchBend(channel, pitch)		CAVEPitchBend(channel,  pitch)

#endif
