/*****************************************************************************/
/* Copyright 1992-1994. Mark C. Surles.  All Rights Reserved */
/*****************************************************************************/
/* Interface for Id class.

   The Id class holds is a handle for Geometry inserted into the display list,
   DispObjList.  Geometry is inserted into a DispObjList by adding it to the
   GeometryList.  If the program is using graphics, the GeometryList then
   inserts the Geometry into the DispObjList.  Only the constructor and 
   DispObjList can assign values to this class.

   The class has two values, an object number and an element number.  The 
   first is the identification number for the Geometry and the second is an
   identification for objects within the Geometry (e.g. a cylinder may have
   an outer shell and an axis).  The element number is used when a sub-part of
   an object has been picked.

   One important example is for referencing a point in the global list of
   points.  The object number is blah (usually irrelevant, because one know
   by the context whether the list of points is referred to), but the element
   number refers to the point (in a ONE-base system).

   The routine Id_valid_range must be called at program initialization to
   specify the valid range of IDs.  This ensures a unique correspondance
   between Id's generated on multiple machines.

   When the plain constructor is called, Id(), a new, unique object number
   is reserved.  The Id is returned when the object is deleted.  Because of
   this, that constructor and destructor must only be called during single
   thread regions of the system.
 *****************************************************************************/

#ifndef IdH
#define IdH

#include "global.h"

/* Object number for an invalid object */
#define ID_INVALID_ID -9999

/* Element number when referring to the entire object */
#define ID_ENTIRE_OBJECT   0

/*****************************************************************************/
void Id_valid_range(int from, int to);


class Id
{
  short  obj_num;				  /* object number */
  short  element_num;				  /* element number */
  short  original_id;
 public:
  Id();
  Id(int point_num);
  Id(int obj, int elem);
  Id(Id *in);
  ~Id();

  short object();
  short element();

  void dump(char *s = 0);
};

/*****************************************************************************/
/*			       Inlined functions                             */
/*****************************************************************************/

inline short Id::object()          { return obj_num; }
inline short Id::element()         { return element_num; }

#endif
