/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: AnimateFormsObj.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/05/11 21:14:49 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu to control the animation of molecules.
 *
 ***************************************************************************/
#ifndef ANIMATEFORMSOBJ_H
#define ANIMATEFORMSOBJ_H

#include "FormsObj.h"


class AnimateFormsObj : public FormsObj {

private:
  // set the state of the anim direction controls based on the top mol
  void reset_dir_controls(void);
  
  // set the status of the current frame, based on the top mol
  void reset_frame_counter(void);

  // set the state of other data items for this menu based on the top mol
  void reset_status_items(void);
  
  // current direction of animation buttons
  int buttonMode;

  // current values in frame status box
  int currFrame, totFrame;

protected:
  // check if the given forms pointer is one for this menu, and generate
  // a command if necessary.  Return 'TRUE' if the pointer is for an object
  // in this menu.
  virtual int check(FL_OBJECT *);

  // do form-specific acting on commands
  virtual int forms_act_on_command(int, Command *, int);

public:
  // class constructor and destructor
  AnimateFormsObj(UIList *, CommandQueue *, int, int, int * = NULL);
  virtual ~AnimateFormsObj(void);

  //
  // virtual routines for UI init/display
  //
  
  // initialize the user interface
  virtual void init(void);
  
  // reset the user interface (forces update of all info displays)
  virtual void reset(void);

  // update the interface display for each screen redraw
  virtual void update(void);

};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: AnimateFormsObj.h,v $
 * Revision 1.4  1995/05/11  21:14:49  billh
 * Moved log messages to end of file.
 *
 * Revision 1.3  95/03/24  18:46:51  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.2  1994/10/21  03:52:41  billh
 * Now keeps track of what numbers are displayed in frame counter box, to
 * speed display.
 *
 * Revision 1.1  1994/10/20  01:30:58  billh
 * Initial revision
 *
 ***************************************************************************/
