/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: AtomSel.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.12 $      $Date: 1995/05/11 21:36:18 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * Parse and maintain the data for selecting atoms.
 *
 ***************************************************************************/
#ifndef ATOMSEL_H
#define ATOMSEL_H

#include <string.h>
#ifdef ARCH_HPUX9
#include <regex.h>
#endif
#include "utilities.h"
#include "Tree.h"

class MoleculeList;
class BaseMolecule;

// default atom selection, and max cmd string size
#define DEFAULT_ATOMSEL		AtomSel::ALL
#define MAX_ATOMSEL_CMD		255

// properly this should go inside of AtomSel, but I get:
// sorry, not implemented: nested class AtomSel::ParseType  BLEH!

// the data type for the binary tree
typedef struct ParseType {
  int op;         // which binary operation am I?
  int compare;     // which kind of compare am I?
  char *data;        // to hold the string of my comparison
  ParseType(void) {  // default values for typedef constructor
      op = 0;
      data = NULL;   // deallocate this yourself!!!
      compare = 0;
  }
  ~ParseType(void) { }
} ParseType;


class AtomSel {

public:
  //   don't change the value of DATA or of NONE , unless you change
  //   ParseType's constructor!!!!!

  // different ways to combine two children, or to say I'm data
  // NOT, AROUND, and PARENS just look at the left child
  enum BinOps { DATA, AND, OR, NOT, PARENS, AROUND, SAME};
  // different methods for selecting atoms
  enum SelMethod {NONE,  ALL, BACKBONE, NAME, TYPE, RESNAME, RESTYPE,
  	RESID, SEGNAME, ID, PROTEIN, NUCLEIC, WATERS, FRAGMENT, 
  	PFRAGMENT, NFRAGMENT, TOTAL };


  // initial string with representation command
  char *cmdStr;
  
  // array of flags, one for each atom in given molecule; 1=selected, 2=not
  char *on;

  // total number of atoms in the molecule selected
  int selected;
  
private:

  Tree<ParseType> *parse_tree;  // contains the parsed search info
  
  // the list of molecules to use for data ... may be NULL
  MoleculeList *molList;

  // molecule used to base the selection on
  BaseMolecule *mol;
  
  // parse the given command, and store results.  Return success.
  int parse_cmd(Tree<ParseType> *);

  // given the parse tree, find the matches
  void parse_find(BaseMolecule *mol, int num, Tree<ParseType> *tree,
    char *on);

  void mark_atoms_given_residue(int residue, char *on);


  // used for the regex checking of various fields
  int has_special(char *str);  // should I regex?
     // compile a regex pattern, return success
  int special_compile(char *pattern);
  int special_compare(char *pattern); // do the regex
  void special_free(void); // delete any alloc'ed space
#ifdef ARCH_HPUX9
  regex_t re;
#endif

public:
  AtomSel(MoleculeList *);
  AtomSel(AtomSel &);
  ~AtomSel(void);
  
  // equal operator, to change the current settings.
  AtomSel& operator=(const AtomSel &);

  // for the given molecule, find atoms for the molecule.  Stores the indices
  // in this object for quick retrieval later.
  // return total number of atoms selected for the molecule.
  int find(BaseMolecule *);

  // provide new settings; does a 'find' at the end if a mol has
  // been previously provided.
  int change(char *newcmd);
  
};

// a string array with text descriptions of representation methods
extern char *AtomSelName[AtomSel::TOTAL];

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: AtomSel.h,v $
 * Revision 1.12  1995/05/11  21:36:18  billh
 * Moved log message to end of file.
 *
 * Revision 1.11  95/03/24  18:47:08  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.10  1994/11/27  12:43:26  dalke
 * added searches for nfrag and pfrag
 *
 * Revision 1.9  1994/11/26  07:36:42  dalke
 * Added a "same" search, as in, "same resname as <selection>"
 *
 * Revision 1.8  1994/11/25  20:39:29  dalke
 * added search for waters
 *
 * Revision 1.7  1994/11/25  13:17:02  dalke
 * Added searches by "protein" (find protein residues) and "nucleic"
 * (find nucleic acid residues)
 *
 * Revision 1.6  1994/11/12  10:24:13  dalke
 * Major revision for "powerful" atom selection
 *
 * Revision 1.5  1994/11/02  08:36:28  billh
 * Added possible 'not' as first word in selection
 *
 * Revision 1.4  1994/11/02  01:33:43  billh
 * Now can have multiple selections.  Still have problem of not seeing
 * resid selections correctly.
 *
 * Revision 1.3  94/10/31  20:33:34  billh
 * Added 'NONE' selection option, and fixed problem with error message disp.
 * 
 * Revision 1.2  94/10/26  23:19:44  billh
 * Removed 'ok' var; removed initial string in constructor; added 'cmd_parse'
 * and operator= routines, as well as 'change' routine.
 * 
 * Revision 1.1  94/09/23  06:01:39  billh
 * Initial revision
 * 
 ***************************************************************************/
