/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdDisplay.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.6 $	$Date: 1995/05/11 22:05:44 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   These are the Commands that control the various aspects
 * of the display, like, the clipping planes, eye separation, etc.
 *
 ***************************************************************************/
#ifndef CMDDISPLAY_H
#define CMDDISPLAY_H

#include "Command.h"
#include "utilities.h"

// These are the Command:: enums used by this file:
//  DISP_RESHAPE, DISP_RESETVIEW, DISP_STEREO, DISP_EYESEP, DISP_FOCALLEN,
//  DISP_LIGHT_ON, DISP_LIGHT_HL, DISP_LIGHT_ROT, DISP_MATERIALS_CHANGE,
//  DISP_CLIP, DISP_DEPTHCUE, DISP_ANTIALIAS,
//  CMD_AXES, CMD_STAGE

// text callback routines for 'display', 'light', 'axes, and 'stage'
extern int text_cmd_display(int, char **, CommandQueue *, int);
extern int text_cmd_light(int, char **, CommandQueue *, int);
extern int text_cmd_axes(int, char **, CommandQueue *, int);
extern int text_cmd_stage(int, char **, CommandQueue *, int);


//////////////////// reshape the display
class CmdDisplayReshape : public Command {
protected:
  virtual int do_execute(void);
public:
  CmdDisplayReshape(int newUIid = (-1));
};


///////////////// reset the current view for the current scene
class CmdResetView : public Command {
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);
public:
  CmdResetView(int newUIid=(-1)) ;
};


//////////////////// set stereo mode of display
class CmdDisplayStereo : public Command {
private:
  int stmode;
protected:
  virtual int do_execute(void);
  virtual void create_text(void);
public:
  CmdDisplayStereo(int newstmode, int newUIid = (-1));
};


//////////////////// set eye separation of display
class CmdDisplayEyesep : public Command {
private:
  float sep;
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);
public:
  CmdDisplayEyesep(float newsep, int newUIid = (-1));
};


//////////////////// set focal length of display
class CmdDisplayFocallen : public Command {
private:
  float flen;
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);
public:
  CmdDisplayFocallen(float newlen, int newUIid = (-1));
};


//////////////////// set screen height value
class CmdDisplayScreenHeight : public Command {
private:
  float val;
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);
public:
  CmdDisplayScreenHeight(float newval, int newUIid = (-1));
};


//////////////////// set distance to screen from origin
class CmdDisplayScreenDistance : public Command {
private:
  float val;
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);
public:
  CmdDisplayScreenDistance(float newval, int newUIid = (-1));
};


//////////////////// turn on/off antialiasing
class CmdDisplayAAOn : public Command {
private:
  int onoff;
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);
public:
  CmdDisplayAAOn(int turnon, int newUIid = (-1));
};


//////////////////// turn on/off depth cueing
class CmdDisplayDepthcueOn : public Command {
private:
  int onoff;
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);
public:
  CmdDisplayDepthcueOn(int turnon, int newUIid = (-1));
};


/////////////////////  clipping plane controls
// This handles the whole range of clipping plane options
//  There are derived classes so you won't have to have the funky flags
// to change {near,fixed} clipping plane {to a fixed,by a relative} amount
// or not
class CmdDisplayClip : public Command {
private:
  int changenear;		// near (T) or far (F) clip plane
  int setval;			// absolute (T) or relative (F) change
  float amount;			// how much to change
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);
public:
  CmdDisplayClip(int ischangenear, int issetval, float newamt, int UIid = -1);
};


//  Change the near clipping plane to a fixed value
// leaving everything else up to the base class :)
class CmdDisplayClipNear : public CmdDisplayClip {
 public:
   CmdDisplayClipNear( float near, int UIid = -1) : 
        CmdDisplayClip(TRUE, TRUE, near, UIid) {
   }
};

//  Change the near clipping plane to by a relative value
class CmdDisplayClipNearRel : public CmdDisplayClip {
 public:
   CmdDisplayClipNearRel( float near, int UIid = -1) : 
         CmdDisplayClip(TRUE, FALSE, near, UIid) {
   }
};

//  Change the far clipping plane to a fixed value
class CmdDisplayClipFar : public CmdDisplayClip {
 public:
   CmdDisplayClipFar( float far, int UIid = -1) : 
          CmdDisplayClip(FALSE, TRUE, far, UIid) {
   }
};

//  Change the far clipping plane to by a relative value
class CmdDisplayClipFarRel : public CmdDisplayClip {
 public:
   CmdDisplayClipFarRel( float far, int UIid = -1) : 
          CmdDisplayClip(FALSE, FALSE, far, UIid) {
   }
};


////////////////////  change the axes location
class CmdDisplayAxes : public Command {
private:
  int newpos;
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);
public:
  CmdDisplayAxes(int npos, int newUIid = (-1));
};
    

////////////////////  change the stage location
class CmdDisplayStage : public Command {
public:
  // stage settings this can affect
  enum Settings { LOCATION, PANELS };

private:
  int newpos;
  int settingToChange;

protected:
  virtual int do_execute(void);
  virtual void create_text(void);
public:
  CmdDisplayStage(Settings toset, int npos, int newUIid = (-1));
};


//////////////////// turn on/off the Nth light
class CmdDisplayLightOn : public Command {
private:
  int n, onoff;
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);
public:
  CmdDisplayLightOn(int ln, int turnon, int newUIid = (-1));
};


//////////////////// highlight the Nth light
class CmdDisplayLightHL : public Command {
private:
  int n, hl;
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);
public:
  CmdDisplayLightHL(int ln, int highlt, int newUIid = (-1));
};


//////////////////// rotate the position of the Nth light
class CmdDisplayLightRot : public Command {
private:
  float theta;
  char axis;
  int n;
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);
public:
  CmdDisplayLightRot(int ln, float th, char ax, int newUIid = (-1));
};


#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: CmdDisplay.h,v $
 * Revision 1.6  1995/05/11  22:05:44  billh
 * Added 'create_text' function to create text representation "on demand".
 * Added text callback functions which are added by UIText, and which are
 * called when a text command is entered and the first word is recognized.
 *
 * Revision 1.5  95/03/24  18:47:45  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.4  1994/11/02  07:31:00  billh
 * Added commands to change display screen size and distance to screen.
 *
 * Revision 1.3  94/10/03  01:39:42  dalke
 * Took code from .h to .C, leaving only prototypes (to reduce inlining)
 * 
 * Revision 1.2  1994/09/05  22:50:38  billh
 * Added complete support for commands to position the axes and stage.
 *
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 * 
 ***************************************************************************/
