/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdRender.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/05/13 01:12:34 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  Render a scene (so far, there is only one, the global one) as some
 * sort of rendered output; postscipt, rayshade, POVray, raster3D, etc.
 *
 ***************************************************************************/

#include "CmdRender.h"
#include "Scene.h"
#include "DisplayDevice.h"
#include "FileRenderList.h"
#include "CommandQueue.h"
#include "Global.h"
#include "utilities.h"

// the following uses only the Cmdtypes RENDER and RENDERLIST

////////////////////////////////////////////////////////////////////
///////////////////////  text processors
////////////////////////////////////////////////////////////////////

// text callback routine for 'render'; return TRUE if an error occurs.
int text_cmd_render(int argc, char **argv, CommandQueue *cmdQueue, int id) {

  if(argc >= 3) {
    char *extstr = NULL;
    if(argc > 3)
      extstr = combine_arguments(argc, argv, 3);
    cmdQueue->append(new CmdRender(argv[1], argv[2], extstr, id));
    if(extstr)
      delete [] extstr;

  } else if (argc == 2 && !strupncmp(argv[1], "list", CMDLEN)) {
    cmdQueue->append(new CmdRenderList(id));

  } else
    return TRUE;

  // if here, everything worked out ok
  return FALSE;
}


///////////////////////// render the global scene
CmdRender::CmdRender(char *newmethod, char *newfilename, char *newcmd, int id)
	: Command(Command::RENDER, id) {
  sc = ::scene;				// get the global scene
  display = ::display;			// ditto for disp. dev.
  filename = stringdup(newfilename);
  method = stringdup(newmethod);
  extcmd = (newcmd ? stringdup(newcmd) : NULL);
}

CmdRender::~CmdRender(void) {
  delete [] filename;
  delete [] method;
  if(extcmd)  delete [] extcmd;
}

int CmdRender::do_execute(void) {
  // do the rendering
  int retval = sc -> filedraw(method, filename, display);

  // if successful, execute external command
  if(retval && extcmd) {
    char *strbuf = new char[strlen(extcmd) + strlen(filename) + 16];
    sprintf(strbuf, extcmd, filename);
    system(strbuf);
  }

  // return result
  return retval;
}

void CmdRender::create_text(void) {
  *cmdText << "render " << method << " " << filename;
  if(extcmd)
    *cmdText << " " << extcmd;
  *cmdText << ends;
}


/////////////////////// list the available rendering types
CmdRenderList::CmdRenderList(int id) : Command(Command::RENDERLIST, id) { }

int CmdRenderList::do_execute(void) {
   if (fileRenderList->num() == 0) {
     msgInfo << "There are currently no possible output formats." << sendmsg;
   } else {
     msgInfo << "The valid image output formats are:" << sendmsg;
     for (int i=0; i<fileRenderList->num(); i++) {
       msgInfo << i+1 << "  " << fileRenderList->name(i) << sendmsg;
     }
   }

   return TRUE;
}

void CmdRenderList::create_text(void) {
  *cmdText << "render list" << ends;
}


/* REVISION HISTORY:********************************************************
 *
 * $Log: CmdRender.C,v $
 * Revision 1.4  1995/05/13  01:12:34  billh
 * Added extra argument to CmdRender: now can specify optional
 * external command which will be run after rendering the scene.  New
 * format is:
 * 	render <method> <filename> [optional command]
 *
 * Revision 1.3  1995/05/11  22:06:14  billh
 * Added 'create_text' function to create text representation "on demand".
 * Added text callback functions which are added by UIText, and which are
 * called when a text command is entered and the first word is recognized.
 *
 * Revision 1.2  95/05/06  18:54:02  khamer
 * Activated and corrected filerender hooks
 * 
 * Revision 1.1  1995/03/24  18:48:05  billh
 * Initial revision
 * 
 ***************************************************************************/
