/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: DisplayFormsObj.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/05/11 22:38:01 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu to control the state of the current display device.
 *
 ***************************************************************************/
#ifndef DISPLAYFORMSOBJ_H
#define DISPLAYFORMSOBJ_H

#include "FormsObj.h"
#include "LightList.h"


class DisplayFormsObj : public FormsObj {

private:
  // set the state of the light browsers
  void reset_light_controls(void);
  
  // set the state of the clipping plane and stereo controls
  void reset_clip_stereo_controls(void);
  
  // set the state of the stereo mode
  void reset_stereo_mode(void);

  // set the state of display toggles
  void reset_toggle_controls(void);

  // set the state of the extra displayed items (axes and stage)
  void reset_displayed_items(void);
  
  // set the state for text status
  void reset_status_items(void);

  // most recent settings for the light browsers
  int lightOn[DISP_LIGHTS];

protected:
  // check if the given forms pointer is one for this menu, and generate
  // a command if necessary.  Return 'TRUE' if the pointer is for an object
  // in this menu.
  virtual int check(FL_OBJECT *);

  // do form-specific acting on commands
  virtual int forms_act_on_command(int, Command *, int);

public:
  // class constructor and destructor
  DisplayFormsObj(UIList *, CommandQueue *, int, int, int * = NULL);

  //
  // virtual routines for UI init/display
  //
  
  // initialize the user interface
  virtual void init(void);
  
  // reset the user interface (forces update of all info displays)
  virtual void reset(void);

};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: DisplayFormsObj.h,v $
 * Revision 1.4  1995/05/11  22:38:01  billh
 * Moved log messages to the end of the file.
 *
 * Revision 1.3  95/03/24  18:49:01  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.2  1994/11/02  07:32:23  billh
 * Added controls and support to change screen height and dist from origin.
 *
 * Revision 1.1  94/09/29  20:58:48  billh
 * Initial revision
 * 
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
