/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: EditFormsObj.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/11 22:45:55 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu to edit the animation lists of molecules.
 *
 ***************************************************************************/
#ifndef EDITFORMSOBJ_H
#define EDITFORMSOBJ_H

#include "FormsObj.h"


class EditFormsObj : public FormsObj {

private:
  // reset the form to a particular animation action
  void reset_action(int);
  
  // reset the form to a particular amount
  void reset_amount(int);

protected:
  // check if the given forms pointer is one for this menu, and generate
  // a command if necessary.  Return 'TRUE' if the pointer is for an object
  // in this menu.
  virtual int check(FL_OBJECT *);

  // do form-specific acting on commands
  virtual int forms_act_on_command(int, Command *, int);

public:
  // class constructor and destructor
  EditFormsObj(UIList *, CommandQueue *, int, int, int * = NULL);

  //
  // virtual routines for UI init/display
  //
  
  // initialize the user interface
  virtual void init(void);
  
  // reset the user interface (forces update of all info displays)
  virtual void reset(void);

};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: EditFormsObj.h,v $
 * Revision 1.3  1995/05/11  22:45:55  billh
 * Moved log messages to the end of the file.
 *
 * Revision 1.2  95/03/24  18:49:17  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1994/11/22  08:29:05  billh
 * Initial revision
 *
 ***************************************************************************/
