/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: FileRenderList.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/05/11 22:45:59 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * The FileRenderList class maintains a database of avbailable FileRenderer
 * objects
 *
 ***************************************************************************/
#ifndef FILERENDERLIST_H
#define FILERENDERLIST_H

#include "NameList.h"
class FileRenderer;


class FileRenderList {

private:
  // list of FileRenderer objects, with their name as a lookup key
  NameList<FileRenderer *> renderList;

public:

  // constructor/destructor
  FileRenderList(void);
  virtual ~FileRenderList(void);
  
  // add a new render class and its corresponding name
  void add(FileRenderer *);
  
  // figure out how many render classes are installed
  int num(void);
  
  // return the name for the ith class
  char * name(int);
  
  // given a render name, return the corresponding class
  FileRenderer *find(char *);
  
};
  
#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: FileRenderList.h,v $
 * Revision 1.2  1995/05/11  22:45:59  billh
 * Moved log messages to the end of the file.
 *
 * Revision 1.1  95/05/04  20:35:19  khamer
 * Initial revision
 * 
 ***************************************************************************/
