/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: GLRenderer.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.7 $	$Date: 1995/05/11 22:49:06 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Subclass of DisplayDevice, this object has routines used by all the
 * different display devices that are GL-specific.  Will render drawing
 * commands into a single GL window.  This is not the complete definition,
 * however, of a DisplayDevice; something must provide routines to open
 * windows, reshape, clear, set perspective, etc.  This object contains the
 * code to render a display command list.
 *
 ***************************************************************************/
#ifndef GLRENDERER_H
#define GLRENDERER_H

#include <gl.h>
#include <gl/device.h>
#include <math.h>
#include "DisplayDevice.h"

#ifndef __NPGL__
#include <gl/sphere.h>
#endif

class GLRenderer : public DisplayDevice {

private:
  // pointer to data block (should be changed to allow for multiple blocks)
  float *dataBlock;
  
  // do we need to turn antialiasing and depth-cueing on when materials
  // are turned off?
  int need_aaon, need_cueon;

  // do we have a currently-defined pop-up menu?
  PopupMenu *mainMenu;

protected:
  // routines to perform various GL-specific graphics operations
  void set_line_width(int);
  void set_line_style(int);
  void set_sphere_res(int);
  void set_sphere_mode(int);
  void triangle(float *x1, float *x2, float *x3, // triangle with normals
		float *n1, float *n2, float *n3);
  void square(float *norm, float *, float *, float *, float *); 
  void cylinder(float *, float *, int, float);  // slow
#ifndef USE_SLOW_CYLINDERS
  void cylinder(int num, float *edges);  // fast, if precomputed
#endif
  void cone(float *, float *, int, float);
  
  //
  // protected virtual routines
  //
  
  // virtual routines to deal with light sources at device level
  // all return success of operation
  virtual int do_define_light(int n, float *color, float *position);
  virtual int do_activate_light(int n, int turnon);

  // virtual routines to deal with materials at device level
  // all return success of operation
  virtual int do_define_material(int n, float *data);
  virtual int do_activate_material(int n, int turnon);

public:
  // constructor/destructor
  GLRenderer(char *);
  virtual ~GLRenderer(void);

  //
  // get the current state of the device's pointer (i.e. cursor if it has one)
  //

  virtual int x(void);		// abs pos of cursor from lower-left corner
  virtual int y(void);		// same, for y direction
  virtual int button_down(int);	// whether a button is currently pressed

  // allow the user to define a special shape for the cursor ... the data
  // is assumed to consist of a single-dim array of 32 unsigned shorts; the
  // first 16 define a 16x16-bit (row-major) pattern, the last 16 are a
  // "second layer" which may be drawn in a different color
  // args: which shape (>0, with 0 the "default" case which cannot be changed)
  // the bitmap data, and the "hot spot" from the lower-left corner
  virtual void change_cursor_shape(int, unsigned short *, int, int);

  // set the Nth cursor shape as the current one.  If no arg given, the
  // default shape (n=0) is used.
  virtual void set_cursor(int = 0);

  //
  // virtual routines to affect the device's transformation matrix
  //
  
  virtual void push(void);		// push device's curr state on stack
  virtual void pop(void);		// pop device's curr state from stack
  virtual void loadmatrix(Matrix4 &);	// replace trans matrix with given one
  virtual void multmatrix(Matrix4 &);	// multiply trans matrix with given one

  //
  // virtual routines to find characteristics of display itself
  //

  // return absolute 2D screen coordinates, given 2D or 3D world coordinates.
  virtual void abs_screen_loc_3D(float *, long *);
  virtual void abs_screen_loc_2D(float *, long *);

  // size of physical display object
  virtual void screen_size_mm(long &, long &);
  virtual void screen_size_pixel(long &, long &);

  // Given a 3D point (pos A),
  // and a 2D rel screen pos point (for pos B), computes the 3D point
  // which goes with the second 2D point at pos B.  Result returned in B3D.
  virtual void find_3D_from_2D(float *A3D, float *B2D, float *B3D);

  //
  // virtual functions to turn on/off depth cuing and antialiasing
  //
  
  virtual void aa_on(void);
  virtual void aa_off(void);
  virtual void cueing_on(void);
  virtual void cueing_off(void);

  //
  // virtual routines to create and activate a popup (possibly pull-down) menu 
  //

  // given a PopupMenu definition, create it in the window (but do not
  // activate it yet).  Return success.
  virtual int menu_create(PopupMenu *);

  // activate a previously-created menu.  If the windowing system has no
  // current menu, or cannot do this operation, returns (-1); otherwise,
  // returns the return code for the select (-1 if none selected).
  virtual int menu_activate(void);

  // delete the given menu from the display.
  // If no argument is given, deletes the current menu (if any).
  // Returns success.
  virtual int menu_delete(PopupMenu * = NULL);

  //
  // virtual routines for preparing to draw, drawing, and finishing drawing
  //
  
  virtual void render(void *);		// process list of draw cmds

};

#endif

/***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: GLRenderer.h,v $
 * Revision 1.7  1995/05/11  22:49:06  billh
 * Added virtual functions to queue and check events, and to get/modify
 * the cursor position, shape, etc.  All graphics/windowing-specific
 * functions have now been moved to the DisplayDevice.
 *
 * Revision 1.6  95/04/11  09:46:51  dalke
 * new formate for the DTRIANGLE that allows different normals
 * for the triangle verticies.
 * 
 * Revision 1.5  1995/03/24  18:49:38  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 *
 * Revision 1.4  1995/03/10  07:49:33  dalke
 * added fast cylinders by precomputing in the DispCmd
 * This makes things about 2.5 times faster for pure cylinder
 * drawing.
 *
 * Revision 1.3  1995/02/22  04:07:05  billh
 * Added virtual routine find_3D_from_2D, which takes a 3D point at pos A,
 * and 2D rel screen position at B, and returns the 3D point corresponding
 * to the 2D point at B in the same plane as point A.
 *
 * Revision 1.2  94/10/04  22:07:55  billh
 * Took out sphere library usage if __NPGL__ is defined, since the npgl lib
 * does not have a version of the sphere drawing routines.  Spheres are
 * just drawn as points for npgl rendering.
 * 
 * Revision 1.1  94/09/23  06:01:39  billh
 * Initial revision
 * 
 ***************************************************************************/
