/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: Geometry.C,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.3 $      $Date: 1995/05/11 22:58:56 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The base class for all objects which measure the geometry of some item
 * such as a molecule.  Each Geometry object is assumed to measure info
 * between N items, where each item is the ith component in an object j.
 * The geometry object must be able to calculate a value for these items,
 * and must have the ability to draw a marker representing the geometry and
 * it's value to a Displayable's drawing list.
 *
 ***************************************************************************/

#include "Geometry.h"
#include "utilities.h"

//////////////////////////  constructor
Geometry::Geometry(int n) {
  objIndex = new int[n];
  comIndex = new int[n];
  geomValue = 0.0;
  numItems = n;
  isOn = hasValue = TRUE;
}


////////////////////////// destructor: free up spaced used
Geometry::~Geometry(void) {
  delete [] objIndex;
  delete [] comIndex;
}


///////////////////////  public virtual routines  ///////////////////////////
  
// return the name of this geometry marker; by default, just blank
char *Geometry::name(void) { return ""; }

// return 'unique' name of the marker, which should be different than
// other names for different markers of this same type
char *Geometry::unique_name(void) { return name(); }

// recalculate the value of this geometry, and return it
float Geometry::calculate(void) { return 0.0; }
  
// calculate a whole list of items, if this object can do so.  Return success.
int Geometry::calculate_all(ResizeArray<float> &) { return FALSE; }

// draw the geometry marker in the given Displayable's drawing list
void Geometry::draw_marker(Displayable *) { }

// check whether the geometry value can still be calculated
int Geometry::ok(void) { return TRUE; }

/* REVISION HISTORY:********************************************************
 *
 * $Log: Geometry.C,v $
 * Revision 1.3  1995/05/11  22:58:56  billh
 * Moved log message to end of file.
 *
 * Revision 1.2  95/04/05  19:19:16  billh
 * Fixed problem with specifying atoms to be picked when the name is not 
 * unique ... the full atom name is now of the form "mol_id/atom_index",
 * which is unique for all the atoms in the currently loaded molecules.
 * Users can request an atom with the previous syntax, but that may not
 * get the right atom due to the possibility of have two or more atoms
 * in a single residue have the same atom name.
 * 
 * Revision 1.1  95/03/24  18:49:40  billh
 * Initial revision
 * 
 ***************************************************************************/
