/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Grid.c,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/11 22:59:21 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  Template to read an nx, ny, nz grid of <T> data
 *
 ***************************************************************************/

#include <malloc.h>
#include "Grid.h"

template<class T>
Grid<T>::Grid(int numx, int numy, int numz)
{
   nx = numx;
   ny = numy;
   nz = numz;

   data = (T*** )malloc(numx * sizeof(T**));
   for (int i=0; i<numx; i++) {
      data[i] = (T**) malloc(numy*sizeof(T*));
      for (int j=0; j<numy; j++) {        // I wonder if I should new this
	 data[i][j] = (T*) malloc(numz*sizeof(T)); // instead?  It works anyway
      }
   }
}

template <class T>
Grid<T>::~Grid(void)
{
   for (int i=0; i<nx; i++) {
      for (int j=0; j<ny; j++) {
	 free(data[i][j]);
      }
      free(data[i]);
   }
   free(data);
}

/* REVISION HISTORY:********************************************************
 *
 * $Log: Grid.c,v $
 * Revision 1.3  1995/05/11  22:59:21  billh
 * Moved log message to end of file.
 *
 * Revision 1.2  95/03/24  18:50:12  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1995/02/12  07:27:08  dalke
 * Initial revision
 *
 ***************************************************************************/
