/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Inform.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/05/11 23:01:52 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Inform - takes messages and displays them to the given ostream.
 *
 ***************************************************************************/

#include <strstream.h>
#include <string.h>
#include "Inform.h"
#include "utilities.h"

// initial 4 instances of this class
Inform msgInfo("Info");
Inform msgWarn("Warning");
Inform msgErr("ERROR");
Inform msgDebug("** Debug **", FALSE);

/////////////////////////  manipulator functions  

// signal we wish to send the message
Inform& sendmsg(Inform& inform) { return inform.send(); }

// set the current msg level
Inform& level1(Inform& inform) { return inform.msg_level(1); }
Inform& level2(Inform& inform) { return inform.msg_level(2); }
Inform& level3(Inform& inform) { return inform.msg_level(3); }
Inform& level4(Inform& inform) { return inform.msg_level(4); }
Inform& level5(Inform& inform) { return inform.msg_level(5); }
Inform& level6(Inform& inform) { return inform.msg_level(6); }
Inform& level7(Inform& inform) { return inform.msg_level(7); }
Inform& level8(Inform& inform) { return inform.msg_level(8); }
Inform& level9(Inform& inform) { return inform.msg_level(9); }
Inform& level10(Inform& inform) { return inform.msg_level(10); }

/////////////////////////  class functions  

// class constructor
Inform::Inform(char *myname, int ison) {
  msgBuf = new char[MAX_MSG_SIZE];
  memset(msgBuf, 0, MAX_MSG_SIZE);
  msg = new ostrstream(msgBuf, MAX_MSG_SIZE);
  
  On = ison;
  msgDest = &cout;
  needNewline = FALSE;
  outputLevel = msgLevel = MIN_MSG_LEVEL;
  
  name = stringdup(myname);
}


// class destructor ... frees up space
Inform::~Inform(void) {
  delete msg;
  delete [] msgBuf;
  delete [] name;
}


// print out the message in the given buffer.  Will modify the string,
// so beware.
void Inform::display_message(char *buf) {
  char *msgptr;

  if(on() && msgLevel <= outputLevel) {
    if(needNewline) {
      (*msgDest) << endl;
      needNewline = FALSE;
    }
    msgptr = strtok(buf, "\n");
    while(msgptr) {
      (*msgDest) << name << " " << msgLevel << ") " << msgptr << endl;
      msgptr = strtok(NULL, "\n");
    }
  }
}


// the signal has been given ... process the message.  Return ref to object.
Inform& Inform::send(void) {
  if(strlen(msgBuf)) {
    display_message(msgBuf);
    msgBuf[0] = '\0';
    delete msg;
    memset(msgBuf, 0, MAX_MSG_SIZE);
    msg = new ostrstream(msgBuf, MAX_MSG_SIZE);
    msgLevel = MIN_MSG_LEVEL;		// reset message level
  }
    
  return *this;
}

/* REVISION HISTORY:********************************************************
 *
 * $Log: Inform.C,v $
 * Revision 1.4  1995/05/11  23:01:52  billh
 * Moved log messages to end of file.
 *
 * Revision 1.3  95/03/24  18:50:14  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.2  1994/10/05  04:38:23  billh
 * Took out double backslash from text, even in comments.
 *
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
