/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeFilePDB.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/05/11 23:18:15 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Read the molecule information from a PDB file
 ***************************************************************************/
#ifndef MOLECULEFILEPDB_H
#define MOLECULEFILEPDB_H

#include "MoleculeFile.h"

// get the coordinate information, then
// makes the connections using a distance search
class MoleculeFilePDB : public MoleculeFile
{
 private:
  // cutoff distance for reading pdb file
  float pdbCutoff;
  char *real_filename;

  // create the molecular structure based on the given .pdb file
  int createFromPDB(char *pdbfile, float cutoff);

  // determine bonds from position of atoms previously read.
  // If the specified Timestep is NULL, then the coordinates stored in the
  // Atom records will be used.
  int find_bonds_from_coordinates(Timestep *, float);


 public:
// If cutoff < 0, use vdw radius to determine if bonded.
   MoleculeFilePDB(char *filename, Scene *, float cutoff = (-1.0));
  // used for the Babel conversion where the real file name is not the
  // name to use in the display
   MoleculeFilePDB(char *realfilename, char *filename, Displayable *, 
                   float cutoff = (-1.0));
   MoleculeFilePDB(char *filename, Displayable *, float cutoff = (-1.0));
   virtual ~MoleculeFilePDB(void);

   // creates the molecule and returns success - also calls
   // the parent class create routines
   virtual int create(void);
};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: MoleculeFilePDB.h,v $
 * Revision 1.4  1995/05/11  23:18:15  billh
 * Moved log messages to end of file.
 *
 * Revision 1.3  95/04/06  17:54:50  dalke
 * Finished interface
 * 
 * Revision 1.2  1995/03/24  18:50:45  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 *
 * Revision 1.1  1995/02/12  07:24:14  dalke
 * Initial revision
 *
 ***************************************************************************/
