/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: PickModeDrag.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/05/11 23:31:21 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * PickModeDrag is a special PickMode which drags the selected atom,
 *  generating a restraint force fed back to Sigma.
 *
 ***************************************************************************/

#include <math.h>
#include <string.h>
#include "PickModeDrag.h"
#include "Pickable.h"
#include "DisplayDevice.h"
#include "Inform.h"


//////////////////////////// constructor  ////////////////////////////
PickModeDrag::PickModeDrag(void) {
  pDrag = NULL;
  needName = FALSE;
}


///////////////////// public virtual routines  ////////////////////////

// called when a pick is begun:
//	args = display to use, obj picked, button, tag, dim, pos
// For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
// For 3D version: x,y,z are transformed position of pointer
void PickModeDrag::pick_start(DisplayDevice *, Pickable *,
				int, int, int, float *) {
    //msgInfo << "drag pick_start tag = " << tag << " dim = " << dim << " pos = "
    //	      << pos[0] << "\t" << pos[1] << "\t" << pos[2] << sendmsg;
}

// called when a pick moves:
void PickModeDrag::pick_move(DisplayDevice *, Pickable *,
				int, int, int, float *) {
    //msgInfo << "drag pick_move tag = " << tag << " dim = " << dim << " pos = "
    //	      << pos[0] << "\t" << pos[1] << "\t" << pos[2] << sendmsg;
}

// called when a pick ends:
void PickModeDrag::pick_end(DisplayDevice *, Pickable *,
				int, int, int, float *) {
    //msgInfo << "drag pick_end tag = " << tag << " dim = " << dim << " pos = "
    //	      << pos[0] << "\t" << pos[1] << "\t" << pos[2] << sendmsg;
}

/* REVISION HISTORY:********************************************************
 *
 * $Log: PickModeDrag.C,v $
 * Revision 1.2  1995/05/11  23:31:21  billh
 * Moved log messages to end of file.
 *
 * Revision 1.1  95/04/05  20:45:59  billh
 * Initial revision
 * 
 ***************************************************************************/
