/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: UIList.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.6 $	$Date: 1995/05/12 00:10:52 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 *  This is the object that maintains the list of all User Interfaces.
 *  The idea is that we create all the UIs (forms, 3D, text, ...) at the
 *  beginning of the program and "register_UI".  Then, during the main
 *  event loop, these UIs are told, first, to check for any events that
 *  occured and put commands on the command queue.  After that step, the
 *  commands are executed and the UIs told about the results of each.
 ***************************************************************************/
#ifndef UILIST_H
#define UILIST_H

#include "ResizeArray.h"
#include "Command.h"
#include "utilities.h"
class UIObject;

/* NOTES:
 *	1) When a UIObject is created, it should be registered with a UIList.
 *	2) There is currently no way to 'unregister' a UI.
 */

class UIList {

private:
  // list of ui objects
  ResizeArray<UIObject *> uilist;

public:
  // constructor/destructor
  UIList(void);
  virtual ~UIList(void);

  // return number of ui's
  int num(void) { return uilist.num(); }

  // return the first UI with given name; NULL if no match found
  UIObject *item(char *);
  
  // return the Nth item
  UIObject *item(int);

  // Stick a new UI in the list and return index (unique, since we do not
  // ever unregister UIObjects)
  int register_UI(UIObject *);

  // make all registered UI's reset     
  void reset_UI(void);
  
  // make all registered UI's init     
  void init_UI(void);

  // make all registered UI's update     
  void update_UI(void);

  // make all registered UI's check for an event     
  void check_event_UI(void);

  // send a Command to the UIs after it has been executed
  void act_on_command_UI(Command::Cmdtype, Command *, int);
  
  // the simpler (and slower) interface
  void act_on_command(Command *);

};  // end class description for UIList

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: UIList.h,v $
 * Revision 1.6  1995/05/12  00:10:52  billh
 * Moved log messages to end of file.
 *
 * Revision 1.5  95/03/24  18:52:22  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.4  1994/10/05  07:05:23  billh
 * moved some routines to .C file.
 *
 * Revision 1.3  1994/10/05  06:58:16  billh
 * Converted to use a ResizeArray instead of a DLinkList in the command queue
 * and ui list.
 *
 * Revision 1.2  1994/10/04  20:29:22  billh
 * Changes to get to compile on HP's ... not there yet,though.
 *
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
