/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: UIObject.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.6 $	$Date: 1995/05/12 00:00:05 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * User Interface Object base class.  All user interface modules are derived
 * from this; it provides methods for registering with the command processor
 * and 'signing up' for which commands it is interested in, as well as
 * generating commands and events.
 *
 ***************************************************************************/

#include "UIObject.h"
#include "UIList.h"
#include "CommandQueue.h"
#include "Command.h"
#include "Inform.h"
#include "utilities.h"


// class constructor: list to register with,, match method
UIObject::UIObject(char *nm, UIList *uil, CommandQueue *cq, match M) {
  int i;
  
  name = stringdup(nm);
  matchMethod = M;
  uiL = uil;
  uiOn = TRUE;
  cmdQueue = cq;

  MSGDEBUG(1,"Creating UIObject '" << name << "' ..." << sendmsg);

  // register this object
  if(uiL) {
    if((myID = uiL->register_UI(this)) < 0) {
      msgErr << "UIObject '" << name << "': cannot register with UIList!"
             << sendmsg;
      matchMethod = NONE;
    }
    maxCmds = Command::TOTAL;
  } else {
    myID = (-1);
    maxCmds = 1;
  }
  
  // init the command flag array  
  doCmd = new char[maxCmds];
  for(i=0; i < maxCmds; doCmd[i++] = FALSE);
}


// destructor; just deregister the UI
UIObject::~UIObject(void) {
// currently, there is no unregister option.
//  if(uiList && myID >= 0)
//    uiList->unregister_UI(myID);
  
  MSGDEBUG(1,"Deleting UIObject '" << name << "' ..." << sendmsg);

  delete [] doCmd;
  delete [] name;
}


// specifically queue a command for later execution.  Return whether
// the command could be queued.
int UIObject::addcommand(Command *cmd) {
  if(cmdQueue && cmd) {

    MSGDEBUG(3,"UIObject '" << name << "': queuing command:\n");
    MSGDEBUG(3,"--> " << *cmd << sendmsg);

    return cmdQueue->append(cmd);
  }
  
  // if here, did not execute
  return FALSE;
}


// send a command to the command queue.  Return command success, or (-1)
// if the command was queued for later execution
int UIObject::runcommand(Command *cmd) {
  if(cmdQueue && cmd) {

    MSGDEBUG(3,"UIObject '" << name << "': executing command:\n");
    MSGDEBUG(3,"--> " << *cmd << sendmsg);

    return cmdQueue->runcommand(cmd);
  }
  
  // if here, did not queue
  return FALSE;
}


////////////////////////// public virtual routines ////////////////////

  //
  // virtual routines to provide information about the UIObject, and turn
  // it on or off
  //

// is this a menu object?
int UIObject::is_menu(void) { return FALSE; }
   
// return whether the UI is active
int UIObject::is_on(void) { return uiOn; }

// turn on UI (allow it to issue commands)
void UIObject::On(void) { uiOn = TRUE; }

// turn off UI (don't allow it to issue commands)
void UIObject::Off(void) { uiOn = FALSE; }

// move the UI object to a new position (may not be applicable)
void UIObject::move(int, int) { }		// by default, does nothing
void UIObject::move(float *) { }		// by default, does nothing

// return where the object is; if not applicable, does nothing
void UIObject::where(int &, int &) { }		// by default, does nothing
void UIObject::where(float *) { }		// by default, does nothing

  //
  // virtual routines for UI init/display
  //
   
// initialize this user interface
void UIObject::init(void) {
  reset();
}
  
// reset the user interface (force update of all info displays)
void UIObject::reset(void) { }
  
// update the displays
void UIObject::update(void) { }

  //
  // virtual routines for entering/processing commands and events
  //
  
// update the display due to a command being executed.  Return whether
// any action was taken on this command.
// Arguments are the command type, command object, and the 
// success of the command (T or F).
int UIObject::act_on_command(int, Command *, int) {
  return FALSE;
}
  
// check for an event, and queue it if found.  Return TRUE if an event
// was generated.
int UIObject::check_event(void) { return FALSE; }


/* REVISION HISTORY:********************************************************
 *
 * $Log: UIObject.C,v $
 * Revision 1.6  1995/05/12  00:00:05  billh
 * Moved log messages to end of file.
 *
 * Revision 1.5  95/03/28  03:46:54  billh
 * Added 'runcommand' routine, to allow a UIObject to request a command be
 * immediately executed instead of going on the queue.
 * 
 * Revision 1.4  95/03/24  18:52:23  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.3  1994/10/19  20:23:08  billh
 * Made 'On' and 'Off' virtual routines in every UIObject, and added virtual
 * routine 'is_on' to test for whether the ui is on or off (used mainly by
 * Mouse to provide options to toggle forms on and off)
 *
 * Revision 1.2  1994/09/12  20:52:56  billh
 * Made some debugging messages L3 instead of L2 (to reduce L2 verbosity).
 *
 * Revision 1.1  94/08/24  03:10:37  billh
 * Initial revision
 * 
 ***************************************************************************/
