/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: UIText.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.17 $	$Date: 1995/05/13 01:41:24 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * This is the User Interface for text commands.  It reads characters from
 * the console, and executes the commands.
 *
 ***************************************************************************/
#ifndef UITEXT_H
#define UITEXT_H

#include <stdio.h>
#include <string.h>
#include "UIObject.h"
#include "Command.h"
#include "Stack.h"
#include "Timer.h"
#include "NameList.h"
#include "Inform.h"


/////////////////////////////  Text Event Object  
class TextEvent : public Command {

public:
  // the text command string
  char *cmd;

private:
  // must the string be deleted when the command is done?
  int deleteCmd;

public:
  // constructor; must specify what the text command string is, whether to
  // delete the string storage, and the the ui id
  // This string must be an allocated array
  TextEvent(char *, int = TRUE, int = (-1));

  // destructor; frees up command string memory if necessary
  virtual ~TextEvent(void);
};




/////////////////////////////  Text User Interface Object   
class UIText : public UIObject {

private:
  // list of commands, and their callback functions and help messages
  NameList<TextCallback *> textProcessors;

  // do we need a prompt displayed?  also, functions to indicate we need one,
  // and to actually display it.
  int needPrompt;
  void need_prompt(void) { needPrompt = TRUE; }
  void prompt(void);

  // files to read text from, if not from stdin
  Stack<FILE *> input_files;
  
  // do we echo VMD commands back to the console after they have been entered?
  int doEcho;

  // Inform object used for echoing commands
  Inform txtMsgEcho;

  // used to delay reading inputs
  Timer mytimer;
  float delay;

public:  
  // constructor
  UIText(UIList *, CommandQueue *);

  // destructor
  virtual ~UIText(void);

  // return number of text commands currently understood
  int num_commands(void);

  // return the Nth word understood; NULL if error
  char *word(int);

  // add a new command to the list of commands
  void add_command(char *, TextCallback *);

  // process an argc, argv command, and return < 0 if the command is not
  // known, 0 if it was successful, or > 0 if an error occcurred
  int process_command(int, char **);

  // specify new file to read commands from
  void read_from_file(char *);

  // set the text processor to wait for the given number of seconds before
  // reading another text command
  void wait(float);

  // get/set whether to echo all VMD text commands to the console
  int echo(void) { return doEcho; }
  void echo(int yn) { doEcho = yn; }

  //
  // virtual routines for entering/processing commands and events
  //
  
  // update the display due to a command being executed.  Return whether
  // any action was taken on this command.
  // Arguments are the command type, command object, and the 
  // success of the command (T or F).
  virtual int act_on_command(int, Command *, int);
  
  // check for an event, and queue it if found.  Return TRUE if an event
  // was generated.
  virtual int check_event(void);
  
};


#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: UIText.h,v $
 * Revision 1.17  1995/05/13  01:41:24  billh
 * Added accessor functions for the text commands; changed to have
 * the screen updated after every Tcl command is executed.
 *
 * Revision 1.16  95/05/12  18:25:23  billh
 * Added Tcl support.
 * 
 * Revision 1.15  95/05/12  00:02:48  billh
 * Using general text command callback function system - UIText maintains
 * a NameList of functions for all the commands it understands.  When a
 * text command is entered, the first word is checked in the list; if found,
 * the text callback function is called to parse and operate on the
 * command.  Thus all the text processing operations have been removed
 * from UIText, and UIText2.C  is no more.  Several new functions have been
 * added to UIText to allow external access to echoing, logging, and other
 * options.  New commands can be added by any other part of VMD by simply
 * providing a word and a callback function.
 * 
 * Revision 1.14  95/04/13  17:13:53  billh
 * Added changes to allow Sigma connection and addition of forces.
 * Added ability to specify words like 'top' and 'fixed' when issuing a
 * command to affect the molecules (i.e. mol list displayed)
 * 
 * Revision 1.13  95/03/24  18:52:28  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.12  1995/03/04  05:14:26  billh
 * Added geomtry labelling commands.
 *
 * Revision 1.11  94/12/06  08:22:44  billh
 * Added color commands.
 * 
 * Revision 1.10  94/11/03  03:41:46  dalke
 * made delay a float
 * 
 * Revision 1.9  1994/11/03  00:14:25  dalke
 * Added the 'wait' command
 *
 * Revision 1.8  1994/10/20  01:32:41  billh
 * Added animation commands.
 *
 * Revision 1.7  1994/10/05  04:38:23  billh
 * Took out double backslash from text, even in comments.
 *
 * Revision 1.6  1994/10/03  08:32:14  dalke
 * Added CmdTool Commands
 *
 * Revision 1.5  1994/10/01  11:01:00  billh
 * Added remote connection commands, put menu parsing commands in a
 * separate routine.
 *
 * Revision 1.4  94/09/17  09:03:30  billh
 * Put in initial molecule commands (load and list).
 * 
 * Revision 1.3  94/09/15  07:03:00  dalke
 * Made tracker text output commands into Commands
 * 
 * Revision 1.2  1994/09/07  07:49:38  dalke
 * added commands to manipulate the trackers via text
 *
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
