/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: VMDTitle.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 1995/05/12 00:10:57 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A flashy title object which is displayed when the program starts up,
 * until a molecule is loaded.
 *
 ***************************************************************************/
#ifndef VMDTITLE_H
#define VMDTITLE_H

#include "Displayable.h"
#include "DispCmds.h"
#include "Timer.h"


class VMDTitle : public Displayable3D {
private:
  DispCmdColorIndex color;
  DispCmdMaterials materials;
  DispCmdTextPos txtpos;
  DispCmdText txt1, txt2, txt3, txt4, txt5;
  Timer timer;
  void redraw_list(void);
  int letterson;
public:
  VMDTitle(Scene *);
  
  // prepare to draw
  virtual void prepare(DisplayDevice *);
};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: VMDTitle.h,v $
 * Revision 1.5  1995/05/12  00:10:57  billh
 * Moved log messages to end of file.
 *
 ***************************************************************************/
