/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: utilities.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.11 $	$Date: 1995/05/12 00:15:04 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * General utility routines and definitions.
 *
 ***************************************************************************/
#ifndef UTILITIES_H
#define UTILITIES_H

#include <string.h>

#ifndef FALSE
#define FALSE 0
#define TRUE  1
#endif

#ifndef NULL
#define NULL 0
#endif

#ifndef ABS
#define ABS(A) ((A)>0?(A):-(A))
#endif

#ifndef PI
#define PI      3.141592653589793
#define TWOPI   2.0 * PI
#endif


// given an argc, argv pair, take all the arguments from the Nth one on
// and combine them into a single string with spaces separating words.  This
// allocates space for the string, which must be freed by the user.
extern char *combine_arguments(int, char **, int);


// make a copy of a string using c++ new routine for memory alloc
extern char *stringdup(const char *);


// convert the given string to upper case
extern char *stringtoupper(char *);


// do case-insensitive string comparisons
extern int strupcmp(char *, char *);
extern int strupncmp(char *, char *, int);


//  break a file name up into path + name, returning both in the specified
//      character pointers.  This creates storage for the new strings
//      by allocating space for them.
extern void breakup_filename(char *, char **, char **);


// take a string and break it up into tokens, of form <keyword> = <value>
extern char *command_tokenize(char *, int *, char **);


// tokenize a given string; return char ptr if ok, NULL if error
extern char *str_tokenize(char *, int *, char **);

// get the time of day from the system clock, and return it (in seconds)
//	(This is supposedly accurate to within about 1 millisecond
extern double time_of_day(void);


// return the username of the currently logged-on user
extern char *username(void);


// print out malloc info to stderr
extern void meminfo(char *);

// compute the cross product, assumes that x1 memory is _different_ 
// than both x2 and x3, and returns the pointer to x1
extern float * cross_prod(float *x1, float *x2, float *x3);

// compute the inner dot product
inline float dot_prod(float *v1, float *v2)
{
 return v1[0]* v2[0] + v1[1]* v2[1] + v1[2] * v2[2];
}

// copy the first 3 elements from v2 to v2
inline void copy(float *v1, float *v2)
{
 memcpy(v1, v2, 3*sizeof(float));
}

// normalizes the 3-vector to length one and returns the pointer
// note that this changes the vector
extern float * normalize(float *);

// subtract 3rd vector from 2nd and put into 1st
// in other words, a = b - c
inline void subtract(float *a, float *b, float *c)
{
 a[0]=b[0]-c[0];
 a[1]=b[1]-c[1];
 a[2]=b[2]-c[2];
}

// add 2nd and 3rd elements, put into 1st
inline void add(float *a, float *b, float *c)
{
 a[0]=b[0]+c[0];
 a[1]=b[1]+c[1];
 a[2]=b[2]+c[2];
}

// compute the midpoint a between two vectors b & c (a = (b + c)/2)
inline void midpoint(float *a, float *b, float *c)
{
 a[0]=0.5*(b[0]+c[0]);
 a[1]=0.5*(b[1]+c[1]);
 a[2]=0.5*(b[2]+c[2]);
}

// compute the angle between two vectors a & b
extern float angle(float *, float *);

// find and return the norm of a 3-vector
extern float norm(float *);

/// conversion from a string to a boolean
// returns TRUE == 1, FALSE == 0, and unknown == -1
extern int str2bool(const char *s);

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: utilities.h,v $
 * Revision 1.11  1995/05/12  00:15:04  billh
 * Moved log messages to end of file.
 *
 * Revision 1.10  95/04/10  09:17:49  dalke
 * added a vector-like copy
 * 
 * Revision 1.9  1995/04/04  21:00:13  billh
 * stringdup now takes arg static char pointer
 *
 * Revision 1.8  95/03/24  18:52:53  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.7  1995/03/04  05:06:34  billh
 * added midpoint and angle routines.
 *
 * Revision 1.6  94/11/02  05:19:23  dalke
 * Added str2bool - a string to boolean converter
 * 
 * Revision 1.5  1994/09/23  07:47:56  dalke
 * Rearranges the vector operations
 *
 * Revision 1.4  1994/09/16  21:34:14  dalke
 * added norm
 *
 * Revision 1.3  1994/09/16  21:26:44  dalke
 * added subtraction of vectors
 *
 * Revision 1.2  1994/09/03  11:06:29  dalke
 * added cross product and normalizing functions
 *
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
