/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: AtomParser.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/06/07 03:53:33 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Basic data types for the yacc/lex interface and for the parse tree
 *
 ***************************************************************************/
#ifndef ATOMPARSER_H
#define ATOMPARSER_H

#include "utilities.h"
#include "String.h"
#include "SymbolTable.h"

// the idea about strings is that some can be regexed.
//  "This" is a double-quoted string  -- can do regex
//  'this' is a single-quoted string  -- don't do regex
//   this  is a raw, or unquoted, string -- don't do regex
enum  atomparser_stringtype {DQ_STRING, SQ_STRING, RAW_STRING};
typedef struct atomparser_string {
	atomparser_stringtype st;
	GString s;
} atomparser_string;

// This is a messy data structure.  Each node of the parse
// tree contains all the data needed for that description
typedef struct atomparser_node {
   int node_type;   // this is an 'AND', 'WITHIN', ...
   int extra_type;  // for weird things like distinguishing
                    // 'index 5 to 7' from 'index 5 7'
   double dval;
   int ival;
   atomparser_string sele;  // if this is a string, what kind of string?
   atomparser_node *left, *right;
   atomparser_node(int nnode_t, int nextra_t = -1) {  // constructor
      node_type = nnode_t;
      extra_type = nextra_t;
      left = NULL;
      right = NULL;
   }
   ~atomparser_node(void) {  // destructor
      if (left) delete left;
      if (right) delete right;
   }
} atomparser_node;

// contains the final parse tree, or NULL if there was an error
extern atomparser_node *atomparser_result;

// given the string and its length, return the index in the symbol table
// or -1 if it isn't there
int atomparser_yylookup(const char *s, int len);

// contains the location of the string to parse
extern char *atomparser_yystring;

// contains the list of the functions and keywords
extern class SymbolTableName **atomparser_symbols;
extern int atomparser_numsymbols;


#endif

