%{
/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: AtomParser.y,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/05/25 16:40:10 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  a parser for atom selections
 *
 ***************************************************************************/



#include <stdio.h>
#include <string.h>
#include "AtomParser.h"
#include "Inform.h"
void yyerror(char *s);
extern "C" int yyparse();
atomparser_node *atomparser_result;
%}

%union {
	int ival;
	double dval;
	atomparser_node *node;
}
	

%type <ival> compare

%token <node> KEY WITHIN WHERE FUNC STRFCTN SAME
%left <node> SINGLE
%nonassoc OF AS
%nonassoc THROUGH
%token ERROR RANGE
%token <dval> FLOAT
%token <ival> INT 
%token <node> WORD
%token COMPARE

%left OR
%left AND
%token LT LE EQ GE GT NE 
%nonassoc <ival> NLT NLE NEQ NGE NGT NNE
%nonassoc <ival> SLT SLE SEQ SGE SGT SNE MATCH 

%left ADD SUB
%left MULT DIV MOD
%left EXP
%left nonassoc NOT
%nonassoc UMINUS

%type <node> selection  expression
%type <node> keyword_list string_list word string_list_ele strfctn_list
%type <dval> number


%%
selection_list:				{// printf("Blank line.\n");
					  atomparser_result =  NULL;
					}
	| selection			{ //printf("Parsed a line\n");
					  if (*atomparser_yystring != 0) {
    msgErr << "Selection terminated too early" << sendmsg;
    if ($1) delete $1;
    $1 = NULL;
					  }
					  atomparser_result = $1;
					}
	| error				{ //printf("Error occured\n");
					  atomparser_result = NULL;
//					  yyerrok;
					}
	;

selection: '(' selection ')'		{ // printf("Parens\n");
					  $$ = $2;
					}
	| NOT selection			{ $$ = new atomparser_node(NOT);
					  $$->left = $2;
					}
	| SINGLE			{ $$ = $1; }
	| SINGLE selection		{ $$ = new atomparser_node(AND);
					  $$->left = $1;
					  $$->right = $2;
					}
	| selection AND selection	{ //printf("AND\n");
					  $$ = new atomparser_node(AND);
					  $$->left = $1;
					  $$->right = $3;
					}
	| selection OR selection	{ //printf("OR\n");
					  $$ = new atomparser_node(OR);
					  $$->left = $1;
					  $$->right = $3;
					}
	| keyword_list			{ $$ = $1; }
	| strfctn_list			{ $$ = $1; }
	| WITHIN number OF selection	{ $$ = new atomparser_node(WITHIN);
					  $$->left = $4;
					  $$->dval = $2;
					}
	| SAME KEY AS selection		{ $$ = $2;
					  $$->node_type = SAME;
					  $$->left = $4;
					}
	| expression compare expression {$$ = new atomparser_node(COMPARE);
					  $$ -> ival = $2;
					  $$ -> left = $1;
					  $$ -> right = $3;
					}
	;

keyword_list: KEY string_list		{
					  $1 -> left = $2;
					  $2 -> right = NULL;
					  $$ = $1;
					}
	;

strfctn_list: STRFCTN string_list	{  $1 -> left = $2;
					   $2 -> right = NULL;
					   $$ = $1;
					}
	;

 word:  WORD				{ 
					  $$ = $1;
					  //printf("Single\n");
					}
	| INT			 	{ $$ = new atomparser_node(WORD);
					  //printf("converted int\n");
					  char s[100];
					  sprintf(s, "%ld", (long) $1);
					  $$ -> sele.s = s;
					  $$ -> sele.st = RAW_STRING;
					}
	| FLOAT				{ $$ = new atomparser_node(WORD);
					  char s[100];
					  sprintf(s, "%lf", (double) $1);
					  $$ -> sele.s = s;
					  $$ -> sele.st = RAW_STRING;
					}
	;

string_list_ele: word			{ 
					  $1 -> right = $1;
   					  $$ = $1; 
					}
	| word THROUGH word		{ $1 -> right = $3;
					  $1 -> left = $3;
					  $1 -> extra_type = 1;
					  $$ = $1;
					  //printf("Using through\n");
					}
	;

string_list:
	string_list_ele			{ $$ = $1; }
        | string_list string_list_ele	{ /* copy the new word on the list */
               /* like a linked list, with head's right pointed to the end */
	       /* element and head's left pointed to the second element    */
				          $1 -> right -> left = $2;
					  $1 -> right = $2 -> right;
					  $2 -> right = NULL;
					  // printf("Returning\n");
					  $$ = $1;
				       }
	;

number: FLOAT				{ $$ = $1;// printf("## %lf\n", $$);
					}
	| INT				{ $$ = (double) $1; 
					  // printf("# %lf\n", $$);
					}
	;

expression: FLOAT			{ $$ = new atomparser_node(FLOAT);
					  $$->dval = $1; 
					}
	|INT				{ $$ = new atomparser_node(INT);
					  $$->ival = $1; 
					}
	| '(' expression ')'		{ $$ = $2; }
	| expression ADD expression	{ $$ = new atomparser_node(ADD);
					  $$->left = $1;
					  $$->right = $3;
					}
	| expression SUB expression	{ $$ = new atomparser_node(SUB);
					  $$->left = $1;
					  $$->right = $3;
					}
	| SUB expression %prec UMINUS	{ $$ = new atomparser_node(UMINUS);
					  $$->left = $2;
					}
	| ADD expression %prec UMINUS	{ $$ = $2;
					}
	| expression MOD expression     { $$ = new atomparser_node(MOD);
					  $$->left = $1;
					  $$->right = $3;
					}
	| expression EXP expression	{ $$ = new atomparser_node(EXP);
					  $$->left = $1;
					  $$->right = $3;
					}
	| expression MULT expression	{ $$ = new atomparser_node(MULT);
					  $$->left = $1;
					  $$->right = $3;
					}
	| expression DIV expression	{ $$ = new atomparser_node(DIV);
					  $$->left = $1;
					  $$->right = $3;
					}
	| KEY				{ $$ = $1; }
	| FUNC '(' expression ')'	{ $1->left = $3;
					  $$ = $1;
					}
	;
					
compare:	  NLT  	{ $$ = NLT; }
		| NLE	{ $$ = NLE; }
		| NEQ	{ $$ = NEQ; }
		| NGE	{ $$ = NGE; }
		| NGT	{ $$ = NGT; }
		| NNE   { $$ = NNE; }
		| SLT  	{ $$ = SLT; }
		| SLE	{ $$ = SLE; }
		| SEQ	{ $$ = SEQ; }
		| SGE	{ $$ = SGE; }
		| SGT	{ $$ = SGT; }
		| MATCH { $$ = MATCH; }
		;


%%

void yyerror(char *s)
{
	fprintf(stderr, "%s\n", s);
}

// everything comes from a string, so there is no way to
// reset "yyin" (or whatever) to the next input
extern "C" yywrap(void)
{
	return 1;
}



