/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: AtomRep.h,v $
 *      $Author: dalke $        $Locker:  $                $State: Exp $
 *      $Revision: 1.11 $      $Date: 1995/05/25 08:19:08 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * Parse and maintain the data for how a molecule should be represented.
 *
 ***************************************************************************/
#ifndef ATOMREP_H
#define ATOMREP_H

#include "utilities.h"

// default atom representation, and max cmd string size
#define DEFAULT_ATOMREP		AtomRep::LINES
#define MAX_ATOMREP_CMD		255

#ifdef VMDALPHA_SHAPE
// This is not yet available outside of the Theoretical Biophysics
// Group and is still under development.
class AlphaShape;
#endif


class AtomRep {

public:
  // different methods for representing atoms
  enum RepMethod { LINES, BONDS, CPK, POINTS, VDW, DOTTED, LICORICE, RIBBONS, 
		   TUBE, 
#ifdef VMDALPHA_SHAPE
ALPHASHAPE,
#endif
REPOFF, TOTAL };

  // initial string with representation command
  char cmdStr[MAX_ATOMREP_CMD + 1];
  
private:
  // results of command ... how to represent atoms, and some parameters
  RepMethod repMethod;
  float sphereRad, bondRad;
  int sphereRes, bondRes, lineThickness;

  // parse the given command, and store results.  Return success.
  int parse_cmd(char *);

public:
  AtomRep(void);
  AtomRep(AtomRep&);
  ~AtomRep(void);
  
  // equal operator, to change the current settings.
  AtomRep& operator=(const AtomRep &);

  // provide new settings
  int change(char *newcmd) { return parse_cmd(newcmd); }

  //
  // info about current settings
  //

  // return representation method
  int method(void) { return repMethod; }
  
  // return sphere radius (may not be applicable)
  float sphere_rad(void) { return sphereRad; }
  
  // return bond radius (may not be applicable)
  float bond_rad(void) { return bondRad; }

  // return sphere res (may not be applicable)
  int sphere_res(void) { return sphereRes; }
  
  // return bond res (may not be applicable)
  int bond_res(void) { return bondRes; }
  
  // return line thickness (may not be applicable)
  int line_thickness(void) { return lineThickness; }

  int option_changed; // set TRUE if the data element changed, so that 
     // representations (like ALPHA, if enabled) dont always recompute
     // the shape when the probe radius value change

#ifdef VMDALPHA_SHAPE
  AlphaShape *alpha;   // the alpha shape

     // Hmm, after a few hours of trying I realized that the following is
     // a very hard thing to do in the current scheme.  The <Add to
     // Selected> doesnt really know what the current selection is
     // about, so there isnt really a way to pass the pointer about.
     // I leave alpha_count here so we can use it during the next/
     // rewrite.
  int *alpha_count;    // During an "Add to [selected|alpha]" of an
                       // alpha shape I let the copy point to the same
		       // file space.  Therefore, I need to keep a reference
		       // count so I do not delete the alpha when something 
		       // else needs it
  void delete_alpha(void);
  void set_alpha(AlphaShape *newalpha);
#endif  

};

// a string array with text descriptions of representation methods
extern char *AtomRepName[AtomRep::TOTAL];

#endif

