/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CaveDisplayDevice.C,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.3 $      $Date: 1995/06/07 02:27:58 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * a CAVE specific display device for VMD
 ***************************************************************************/

#include "CaveDisplayDevice.h"
#include "Inform.h"

// include cave library access
#include <cave.h>


// static string storage used for returning stereo modes
static char *caveStereoNameStr[1] = {"Cave"};

// light model data
static float lightModelData[] = { TWOSIDE, 1.0, LMNULL };


///////////////////////////////  constructor
CaveDisplayDevice::CaveDisplayDevice(void) : GLRenderer("Cave") {

  MSGDEBUG(1, "Creating CaveDisplayDevice ... " << sendmsg);
    
  stereoNames = caveStereoNameStr;
  stereoModes = 1;
  doneGLInit = FALSE;    
    
  // leave everything else up to the cave_gl_init_fn
}


///////////////////////////////  destructor
CaveDisplayDevice::~CaveDisplayDevice(void) {
  // nothing to do
}


/////////////////////////////  public routines  //////////////////////////

// whether a button is currently pressed
int CaveDisplayDevice::button_down(int b) {
  int retval = FALSE;

  if(b == B_LEFT || b == B2_LEFT)
    retval = (int)CAVEBUTTON1;
  else if(b == B_MIDDLE || b == B2_MIDDLE)
    retval = (int)CAVEBUTTON2;
  else if(b == B_RIGHT || b == B2_RIGHT)
    retval = (int)CAVEBUTTON3;
  else
    retval = GLRenderer::button_down(b);

  return retval;
}



// set up the graphics on the seperate CAVE displays
void CaveDisplayDevice::cave_gl_init_fn(void) {

    msgWarn << "CaveDisplayDevice: initializing graphics ..." << sendmsg;

    has2D = FALSE;  //  not that we even _have_ 2D stuff now
    aaAvailable = (getgdesc(GD_PNTSMOOTH_RGB) && getgdesc(GD_LINESMOOTH_RGB));
    cueingAvailable = FALSE;

    RGBmode();
    gconfig();
    zbuffer(1);
    glcompat(GLC_ZRANGEMAP, 0);
    lsetdepth(getgdesc(GD_ZMIN),getgdesc(GD_ZMAX));
    backface(FALSE);
    shademodel(GOURAUD);
    mmode(MVIEWING);
    subpixel(TRUE);

    // define graphics state based on already-set default values
#ifndef __NPGL__
    sphmode(SPH_HEMI,TRUE);
    sphmode(SPH_ORIENT,TRUE);
    sphmode(SPH_TESS,SPH_OCT);
#endif
    set_sphere_mode(sphereMode);
    set_sphere_res(sphereRes);
    set_line_width(lineWidth);
    set_line_style(lineStyle);

    msgWarn << "CaveDisplayDevice: defining lights ..." << sendmsg;
    // turn on lights if necessary
    for(int i=0; i < DISP_LIGHTS; i++) {
      if(lightDefined[i]) {
	do_define_light(i, lightColor[i], lightPos[i]);
	do_activate_light(i, lightOn[i]);
      } else
	do_activate_light(i, FALSE);
    }
    // define the light model ... this never changes.
    // material display is turned on/off by binding MATERIALS.
    lmdef(DEFLMODEL,1,sizeof(lightModelData)/sizeof(float)-1,lightModelData);
    lmbind(LMODEL, 1);

    msgWarn << "CaveDisplayDevice: defining materials ..." << sendmsg;
    // define materials if necessary
    for(i=0; i < MAXCOLORS; i++) {
      if(matDefined[i])
	do_define_material(i, matData[i]);
    }
    do_activate_material(materialOn, materialsActive);
    
    // we want the CAVE to be centered at the origin, and in the range
    // -1, +1
    (transMat.top()).translate(0.0, 3.0, -2.0);
    (transMat.top()).scale(PI);

    // turn on antialiasing and depth-cueing off
    aa_on();
    cueing_off();
}


// cannot change to stereo mode
void CaveDisplayDevice::set_stereo_mode(int) {

}
  

// routines to prepare, draw, and finish, some done by the CAVE
void CaveDisplayDevice::prepare2D(int ) { }               // ready to draw 2D

void CaveDisplayDevice::prepare3D(int do_clear) {         // ready to draw 3D
  if(do_clear)
    clear();
   else
    zclear();
}

void CaveDisplayDevice::clear(void) {                     // erase the device
  unsigned long l;
  l = ( ( (short)(backColor[0] * 255.0) ) |
      ( (short)(backColor[1] * 255.0) << 8) |
      ( (short)(backColor[2] * 255.0) << 16) );
  czclear(l, getgdesc(GD_ZMAX));
}

// special render routine to check for graphics initialization
void CaveDisplayDevice::render(void *cmdlist) {
  if(!doneGLInit) {
    cave_gl_init_fn();
    doneGLInit = TRUE;
  }

  // now do regular rendering
  push();
  multmatrix((transMat.top()));
  GLRenderer::render(cmdlist);
  pop();
}

