/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CaveTracker.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/12 00:39:29 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A CaveTracker is a device for measuring the 3D spacial position of the
 * Cave input device; it is a subclass of the Tracker class.
 *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <cave.h>
#include "CaveTracker.h"
#include "Matrix4.h"


// class constructor
CaveTracker::CaveTracker(char *, int ) : Tracker(1) {
	sensorAvailable[0] = TRUE;
	status = TRACKER_OK;
        // get initial position and orientation
        update_sensors();
}

// class destructor
CaveTracker::~CaveTracker(void) {
}

// function to update the sensor positions from the CAVE macros
// the sensor  field is ignored, as is int do_update
// always returns 
int CaveTracker::my_get_data(int , float *x, float *y, float *z,
  float *orient, int ) {

   CAVEGetWand(*x, *y, *z);
   float azi, elev, roll;
   CAVEGetWandOrientation(azi, elev, roll);
   Matrix4 rot;
   rot.rot(azi, 'y');  // from looking at cave.h
   rot.rot(elev, 'x'); // BTW, this is the classical definition of
   rot.rot(roll,'z');  // Euler angles; not the quantum one

   float *or = orient;
   int j, k;
   for(j=0; j < 3; j++)
     for(k=0; k < 3; k++)
       *(or++) = (float)(rot.mat[j][k]);
   return TRUE;
}


