/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CaveTracker.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/12 00:39:30 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A CaveTracker is a device for measuring the 3D spacial position of the
 * Cave input device; it is a subclass of the Tracker class.
 *
 ***************************************************************************/
#ifndef CAVETRACKER_H
#define CAVETRACKER_H

// project include files
#include "Tracker.h"


class CaveTracker : public Tracker {

protected:
  // virtual routine which reads data from sensors, if available
  // returns TRUE if data read and variables changed, FALSE otherwise;
  virtual int my_get_data(int, float *, float *, float *, float *, int);

public:
  // constructors and destructors
  CaveTracker(char *name, int num_sensors = 1);
  virtual ~CaveTracker(void);

};

#endif

