/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdExternal.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/05/11 22:05:45 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  Turn the UIExternal either on or off
 *
 ***************************************************************************/

#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "CmdExternal.h"
#include "UIExternal.h"
#include "CommandQueue.h"
#include "Global.h"
#include "utilities.h"

// The following use "EXTERNAL_START" and "EXTERNAL_END"

////////////////////////////////////////////////////////////////////
///////////////////////  text processors
////////////////////////////////////////////////////////////////////

// text callback routine for 'external'; return TRUE if an error occurs.
int text_cmd_external(int argc, char **argv, CommandQueue *cmdQueue, int id) {
  if(argc == 2) {
    if (!strupncmp(argv[1], "on", CMDLEN) ||
	!strupncmp(argv[1], "begin", CMDLEN) ||
	!strupncmp(argv[1], "start", CMDLEN)) {
      cmdQueue->append(new CmdExternalStart(id));
    } else if (!strupncmp(argv[1], "off", CMDLEN) ||
	       !strupncmp(argv[1], "end", CMDLEN) ||
	       !strupncmp(argv[1], "stop", CMDLEN)) {
      cmdQueue->append(new CmdExternalEnd(id));
    } else {
      return TRUE;
    }
  } else
    return TRUE;
    
  // if here, everything worked out ok
  return FALSE;
}


////////////////////// start a new external interface
int CmdExternalStart::do_execute(void) { 
   return (uiExternal && uiExternal -> start_listening());
}

void CmdExternalStart::create_text(void) {
  *cmdText << "external start" << ends;
}

CmdExternalStart::CmdExternalStart(int fromUIid)
	: Command(Command::EXTERNAL_START, fromUIid) { }


////////////////////// turn off an external interface
int CmdExternalEnd::do_execute(void) { 
   return (uiExternal && uiExternal -> stop_listening());
}

void CmdExternalEnd::create_text(void) {
  *cmdText << "external end" << ends;
}

CmdExternalEnd::CmdExternalEnd(int fromUIid)
	: Command(Command::EXTERNAL_END, fromUIid) { }


