/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdMenu.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.6 $	$Date: 1995/05/12 05:57:01 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *     The menu commands are defined here.  These tell the app to turn a
 * menu on or off; to move a menu; or print the cooordinates of a menu
 * to infoMsg.  A "menu" is a UIObject that has a window.
 *
 ***************************************************************************/

//// An example of how to move the "main" menu to 12, 50
// commandQueue->append(new CmdMenuMove(uiList->item("main"),12,50))

#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include "CmdMenu.h"
#include "UIObject.h"
#include "UIList.h"
#include "CommandQueue.h"
#include "Global.h"
#include "utilities.h"

// The following uses the Cmdtypes "MENU_SHOW", "MENU_MOVE", and
// "MENU_LOC" from the Command class

////////////////////////////////////////////////////////////////////
///////////////////////  text processors
////////////////////////////////////////////////////////////////////

// text callback routine for 'menu'; return TRUE if an error occurs.
int text_cmd_menu(int argc, char **argv, CommandQueue *cmdQueue, int id) {

  // make sure a menu was named
  if(argc < 2)
    return TRUE;

  UIObject *ui = uiList->item(argv[1]);
  if(ui && ui->is_menu()) {		// menu name is valid
    if(argc == 3) {
      if(!strupncmp(argv[2],"on",CMDLEN))
        cmdQueue->append(new CmdMenuShow(ui->id(), TRUE, id));
      else if (!strupncmp(argv[2],"off",CMDLEN))
        cmdQueue->append(new CmdMenuShow(ui->id(), FALSE, id));
      else if (!strupncmp(argv[2],"loc",CMDLEN))
        cmdQueue->append(new CmdMenuLoc(ui->id(), id));
      else
        return TRUE;
    } else if(argc == 5) {
      if (!strupncmp(argv[2],"move",CMDLEN))
        cmdQueue->append(new CmdMenuMove(ui->id(),atoi(argv[3]),
	  	atoi(argv[4]),id));
      else
	return TRUE;
    } else
      return TRUE;
  } else {
    // an unknown menu was given.  To make it nicer when the GUI is not
    // being used, do not print any error messges.
//    msgErr << "Unknown menu '" << argv[1] << "' specified." << sendmsg;
//    return TRUE;
  }

  // if here, command was found
  return FALSE;
}


//////////// turn a menu on/off
int CmdMenuShow::do_execute(void) {
  if (menu) {
    if(turnOn)
      menu -> On();
    else
      menu -> Off();
  }
  return (menu != NULL ? TRUE : FALSE);
}

void CmdMenuShow::create_text(void) {
  if(menu) {
    *cmdText << "menu " << menu->name << (turnOn ? " on" : " off");
    *cmdText << ends;
  }
}

CmdMenuShow::CmdMenuShow(int changeUIid, int turnon, int fromUIid )
  : Command(Command::MENU_SHOW, fromUIid)  {
  turnOn = turnon;
  toUIid = changeUIid;
  if(toUIid >= 0 && toUIid < uiList->num() && 
  	(uiList->item(toUIid)) -> is_menu() )
    menu = uiList->item(toUIid);
  else
    menu = NULL;
}


//////////// move a menu about
int CmdMenuMove::do_execute(void) {
  if (menu) {
    menu -> move(x,y);           // then move the menu window
  }
  return (menu != NULL ? TRUE : FALSE);
}

void CmdMenuMove::create_text(void) {
  if(menu) {
    *cmdText << "menu " << menu->name << " move " << x << " " << y;
    *cmdText << ends;
  }
}

CmdMenuMove::CmdMenuMove(int changeUIid, int newx, int newy, int fromUIid)
  : Command(Command::MENU_MOVE, fromUIid)  {
  x = newx;
  y = newy;
  toUIid = changeUIid;
  if(toUIid >= 0 && toUIid < uiList->num() && 
  	(uiList->item(toUIid)) -> is_menu() )
    menu = uiList->item(toUIid);
  else
    menu = NULL;
}


//////////// print a menu's location
int CmdMenuLoc::do_execute(void) {
  if (menu) {
    int x, y;
    menu -> where(x,y);           // then move the menu window
    msgInfo << "Menu " << menu->name << " is at " << x << ", " << y
            << sendmsg;
  }
  return (menu != NULL ? TRUE : FALSE);
}

void CmdMenuLoc::create_text(void) {
  if(menu) {
    *cmdText << "menu " << menu->name << " loc";
    *cmdText << ends;
  }
}

CmdMenuLoc::CmdMenuLoc(int changeUIid, int fromUIid)
  : Command(Command::MENU_LOC, fromUIid)  {
  toUIid = changeUIid;
  if(toUIid >= 0 && toUIid < uiList->num() && 
  	(uiList->item(toUIid)) -> is_menu() )
    menu = uiList->item(toUIid);
  else
    menu = NULL;
}

