/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdRender.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/05/13 01:13:28 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Render a scene (so far, there is only one, the global one) as some
 * sort of rendered output; postscipt, rayshade, POVray, raster3D, etc.
 *
 ***************************************************************************/
#ifndef CMDRENDER_H
#define CMDRENDER_H

#include "Command.h"
class Scene;
class DisplayDevice;

// the following uses only the Cmdtypes RENDER and RENDERLIST

// text callback routine for 'render'
extern int text_cmd_render(int, char **, CommandQueue *, int);


///////////////////////// render the global scene
class CmdRender : public Command {

private:
  Scene *sc;     // this is here for the time in the future when we have
                 // multiple scenes
  DisplayDevice *display;  // ditto, for DisplayDevices (there's only one now)
  char *filename;
  char *method;  // what kind of output?  "postscript", "rayshade", etc.
  char *extcmd;  // command to run if the rendering is successful

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  // constructor: method, filename, external cmd, ui id
  CmdRender(char *, char *, char *, int=(-1));
  
  // destructor
  virtual ~CmdRender(void);
};


/////////////////////// list the available rendering types
class CmdRenderList : public Command {

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdRenderList(int=(-1));
};

#endif

