/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ColorUser.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/11 22:11:01 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Simple base class for objects which will be needing to use a ColorList
 * for colors.  This class provides routines for being given a ColorList
 * object, and for being informed of when colors are changed.  The user
 * can create new "categories" of colors in the ColorList, and add specific
 * "color objects" to the category with an identifying name.  The user can
 * edit these colors via commands.
 *
 ***************************************************************************/
#ifndef COLORUSER
#define COLORUSER

class ColorList;


class ColorUser {

protected:
  // a pointer to a ColorList object for this Displayable to use, if
  // one is provided by an external source
  ColorList *colorList;

  // virtual function which is called when a new colorlist is provided.
  // may not need to do anything, which is the default cause
  virtual void do_use_colors(void);

  // do action due to the fact that a color for the given ColorList for
  // the specified category has changed
  virtual void do_color_changed(ColorList *, int);

public:
  // constructor and destructor... really do nothing
  ColorUser(void);
  virtual ~ColorUser(void);
  
  //
  // routines for working with the ColorList
  //
  
  // set up to use a specific ColorList.  This stores the list, and calls
  // a function to do specific action when given a new list
  virtual void use_colors(ColorList *);

  // do action due to the fact that a color for the given ColorList for
  // the specified category has changed.  By default, just does the
  // particular special action.
  virtual void color_changed(ColorList *, int);

};

#endif

