/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Command.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/05/11 22:11:02 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *     This file contains the base definition of the Command object.
 *  The idea is that all actions should be instantiated as
 *  a derivitive of a Command object and placed in a command queue.
 *  At every event loop, the commands are read off the current command
 *  queue and told to "execute".  When each command
 *  is finished, all of the UIs are notified that a command of some 
 *  "cmdtype" executed, so that the UI can update its information 
 *  if so desired.
 *
 ***************************************************************************/

#include "Command.h"
#include "utilities.h"


//////////////////////////////////  constructor
Command::Command(Cmdtype newtype, int newUIid) {
  mytype = newtype;
  UIid = newUIid;
  memset(cmdtextbuf, 0, 256);
  cmdText = new ostrstream(cmdtextbuf, 256);
  textExists = FALSE;
  hasTextCmd = TRUE;
}


//////////////////////////////////  destructor
Command::~Command(void) {
  delete cmdText;
}


///////////////////////////////  private routines  /////////////////////////

// creates text equiv, if necessary
void Command::check_and_create_text(void) {
  if(!textExists) {
    create_text();
    textExists = TRUE;
  }
}


///////////////////////////////  protected routines  /////////////////////////

// virtual function to allow each object to do a different action.
// called by 'execute'.
// By default, does nothing.
int Command::do_execute(void) { return TRUE; }


// virtual function which is called when a text version of the command
// must be created to be printed to the console or a log file.  If a
// special version is not provided, this just creates an empty string.
void Command::create_text(void) {
  // by default, just create an empty string and indicate this command
  // does NOT have a text equivalent that should be printed to a log file
  *cmdText << ends;
  hasTextCmd = FALSE;
}


////////////////////////////////  public routines  ///////////////////////////

// return whether this command has a text equivalent
int Command::has_text(void) {
  // need to construct the string if it has not been done so yet
  check_and_create_text();
  return hasTextCmd;
}


// return return string with command text
char *Command::text(void) {
  // need to construct the string if it has not been done so yet
  check_and_create_text();
  return cmdtextbuf;
}


// Do the action specified for this command.  Return success.
int Command::execute(void) {
  MSGDEBUG(3,"Executing: '" << *this << "' ..." << sendmsg);
  return do_execute();
}

