/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: DrawMolItem.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.16 $	$Date: 1995/05/27 06:31:56 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Child Displayable component of a molecule; this is responsible for doing
 * the actual drawing of a molecule.  It contains an atom color, atom
 * selection, and atom representation object to specify how this component
 * should look.
 *
 ***************************************************************************/
#ifndef DRAWMOLITEM_H
#define DRAWMOLITEM_H

#include "Displayable.h"
#include "DispCmds.h"
#include "AtomColor.h"
#include "AtomRep.h"
#include "AtomSel.h"
#include "ColorList.h"
class DrawMolecule;

class DrawMolItem : public Displayable3D {

public:
  // atom coloring method to use
  AtomColor *atomColor;
  
  // atom representation to use
  AtomRep *atomRep;
  
  // atom selection to use
  AtomSel *atomSel;

private:
  // parent molecule; kept here as a 'DrawMolecule' pointer for convenience
  DrawMolecule *mol;
  
  // useful drawing command objects, used to create display list
  DispCmdData *dataCmd;		// put in block of data with coordinates
  DispCmdColorIndex cmdColorIndex;
  DispCmdColorRGB cmdColorRGB;
  DispCmdTextPosIndex cmdTextPosIndex;
  DispCmdSphereIndex cmdSphereIndex;
  DispCmdLine cmdLine;
  DispCmdTriangle cmdTriangle;
  DispCmdCylinder cmdCylinder;
  DispCmdText cmdTextX;
  DispCmdMaterials cmdMaterials;
  DispCmdSphereRes cmdSphres;
  DispCmdSphereType cmdSphtype;
  DispCmdLineType cmdLineType;
  DispCmdLineWidth cmdLineWidth;
  
  // put in commands to draw with different representations, using the
  // given positions
  void draw_just_spheres(void);	// used for vdw and dotted reps
  void draw_lines(float *);
  void draw_cpk(float *);
  void draw_points(float *);
  void draw_vdw(void);
  void draw_dotted(void);
  void draw_licorice(float *);
  void draw_bonds(float *);
  void make_connection(float *prev, float *start, float *end, float *next,
		       float radius, int resolution, int is_cyl);
  void draw_spline_curve(int num, float *coords, int *idx,
			 int use_cyl, float b_rad, int b_res);
  void draw_spline_ribbon(int num, float *coords, float *perps,
			  int *idx, int use_cyl, float b_rad,
			  int b_res);
  void draw_tube(float *);
  void draw_ribbons(float *);  // use an external call to 'ribbons'
#ifdef VMDALPHA_SHAPE
  void draw_alphaShape(float *); // draw the alpha shape.  Only available
                       // in the Theoretical Biophysics Group as it
		       // is still under development
#endif

  // regenerate the command list
  void create_cmdlist(void);

  // do we need to completely redraw the list?
  // This keeps track of what caused the regeneration
  enum {NO_REGEN = 0, FORCE_REGEN = 1, SEL_REGEN = 2,
	REP_REGEN = 4, COL_REGEN = 8} RegenChoices;
  int needRegenerate;

  // do we need to update the current frame coordinates?
  int needNewFrame;

protected:
  // do action due to the fact that a color for the given ColorList for
  // the specified category has changed
  virtual void do_color_changed(ColorList *, int);

public:
  // constructor: parent molecule, and atom drawing methods
  DrawMolItem(DrawMolecule *, AtomColor *, AtomRep *, AtomSel *);
  virtual ~DrawMolItem(void);
  
  // change the atom coloring method.  Return success.
  int change_color(AtomColor *);
  
  // change the atom representation method.  Return success.
  int change_rep(AtomRep *);
  
  // change the atom selection method.  Return success.
  int change_sel(AtomSel *);

  // return whether the Nth atom is displayed.  This is true if ANY
  // representation is displaying the given atom
  int atom_displayed(int);

  //
  // public virtual routines
  //
  
  // prepare for drawing ... do any updates needed right before draw.
  virtual void prepare(DisplayDevice *);

};

#endif

