/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: Enterprise.C,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.5 $      $Date: 1995/05/11 22:45:56 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Draw the USS Enterprise (NCC 1701 and _not_ 1701D)
 *
 ***************************************************************************/

#include "Enterprise.h"
#include "DisplayDevice.h"
#include "Scene.h"
#include "DispCmds.h"
#include "ColorList.h"
#include "Inform.h"


Enterprise::Enterprise(Scene *sc) : Displayable3D(MULT, "Enterprise", sc, 1) {

  // initialize coordinates for the USS Enterprise, NCC 1701
  hullStart[0]=hullStart[1]=hullStart[2] = 0;  // at the origin
  hullEnd[0]=-1.5; hullEnd[1]=hullEnd[2] = 0;  // along X
  hullRadius = .21;
  
  // warp nacelles, 
  nacelleRadius = .12;
  // port
  nacelle1Start[0] = -.25; nacelle1Start[1] = .40; nacelle1Start[2] = .45;
  nacelle1End[0] = nacelle1Start[0] - 1.5;
   nacelle1End[1] = nacelle1Start[1]; nacelle1End[2] = nacelle1Start[2];
  // and starboard
  nacelle2Start[0] = nacelle1Start[0]; nacelle2Start[1] = -nacelle1Start[1];
   nacelle2Start[2] = nacelle1Start[2];
  nacelle2End[0] = nacelle1End[0]; nacelle2End[1] = -nacelle1End[1];
   nacelle2End[2] = nacelle1End[2];
  
  // saucer section
  saucerRadius = 0.6;
  saucerStart[0] = saucerRadius * 1.2; saucerStart[1] = 0;
  saucerStart[2] = nacelle1Start[2];
  saucerEnd[0] = saucerStart[0]; saucerEnd[1] = saucerStart[1];
  saucerEnd[2] = nacelle1Start[2] * 0.7;
  
  // displayable characteristics
  rot_on();
  scale_on();
  glob_trans_on();
  cent_trans_off();
    
  // since I don't change anything, only create graphics command list once
  create_cmdlist();
}


// create the drawing command list
void Enterprise::create_cmdlist(void ) {
  float tempstart[3], tempend[3];

  MSGDEBUG(1, "Enterprise: creating command list ... " << sendmsg);
  
  // turn on material characteristics
  DispCmdMaterials materials(TRUE);
  materials.put(this);
  
  {// Draw the ship hull
   DispCmdColorIndex hullColor(REGWHITE);
   hullColor.put(this);
   DispCmdCylinder hull(hullStart, hullEnd, hullRadius, 12);
   hull.put(this);
   for (int i=0; i<3; i++) {
     tempstart[i] = hullStart[i];
     tempend[i] = hullEnd[i];
   }
   tempstart[0] += (hullStart[0] - hullEnd[0]) * 0.05;
   tempend[0] -= (hullStart[0] - hullEnd[0]) * 0.05; 
   DispCmdCone hullFront(hullStart, tempstart, hullRadius, 12);
   hullFront.put(this);
   DispCmdCone hullRear(hullEnd, tempend, hullRadius, 12);
   hullRear.put(this);
  }
  
  // draw the warp nacelles
  DispCmdCylinder nacelle1(nacelle1Start, nacelle1End, nacelleRadius, 12);
  nacelle1.put(this);
  DispCmdCylinder nacelle2(nacelle2Start, nacelle2End, nacelleRadius, 12);
  nacelle2.put(this);
  
  // draw the saucer section; a cylinder between two cones
  tempstart[0] = saucerStart[0];
  tempstart[1] = 0;
  tempstart[2] = saucerStart[2] - (saucerStart[2] - saucerEnd[2])*0.15;
  DispCmdCone saucertop( tempstart, saucerStart, saucerRadius, 16);
  saucertop.put(this);
  
  tempend[0] = saucerStart[0];
  tempend[1] = 0;
  tempend[2] = saucerEnd[2] + (saucerStart[2] - saucerEnd[2]) * 0.15;
  DispCmdCone saucerbot( tempend, saucerEnd, saucerRadius, 16);
  saucerbot.put(this);
  
  DispCmdCylinder saucer(tempstart, tempend, saucerRadius, 16);
  saucer.put(this);
  
  // and the (Bussard?) engine intakes
  DispCmdSphereRes sphres(12);
  sphres.put(this);
  DispCmdSphereType sphtype(SOLIDSPHERE);
  sphtype.put(this);
  DispCmdColorIndex intakecol(REGCYAN);
  intakecol.put(this);
  DispCmdSphere intake1(nacelle1Start, nacelleRadius);
  intake1.put(this);
  DispCmdSphere intake2(nacelle2Start, nacelleRadius);
  intake2.put(this);

  DispCmdMaterials materialsoff(FALSE);
  materialsoff.put(this);
}

// prepare the displayable object; just put at origin
#include "TrackerList.h"
#include "Tracker.h"
#include "Matrix4.h"
extern TrackerList *trackerList;
void Enterprise::prepare(DisplayDevice *display) {
  // I don't have to do anything if I remain at the origin (??)

  // however, I test the tracker by connecting to tracker 0 sensor 0
  // if it exists
  if (trackerList -> num() > 0) {
    float x, y, z;
    float orient[9];
    trackerList -> tracker(0) -> get_orientation(0, orient);
    Matrix4 m;
    for (int i=0; i<3; i++)
      for (int j=0; j<3; j++)
        m.mat[i][j] = orient[i*3+j];
    for (i=0; i<3; i++)
      m.mat[i][3] = m.mat[3][i] = 0;
    m.mat[3][3] = 1;
    set_rot(m);

    trackerList -> tracker(0) -> get_position(0, x, y, z); // translation
    glob_trans_on();
    set_glob_trans(x, y, z);
    glob_trans_off();
    
  } else {
    if(display);		// keep compiler happy
  }
}

