/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: FileRenderer.h,v $
 *	$Author: khamer $	$Locker:  $		$State: Exp $
 *	$Revision: 1.10 $	$Date: 1995/05/30 13:53:58 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The FileRenderer class implements the data and functions needed to 
 * render a scene to a file in some format (postscript, raster3d, etc.)
 *
 ***************************************************************************/
#ifndef FILERENDERER_H
#define FILERENDERER_H

// FileRenderer is a class which allows rendering of graphics to
// files, in the form of commands for other programs (raytracers, etc.) 
// or image formats, or whatever.

#include "DisplayDevice.h"

class FileRenderer : public DisplayDevice {

private:

  // pointer to datablock
  float *dataBlock;
  
  // do we need to turn antialiasing and depth-cueing on when materials
  // are turned off?
  
  int need_aaon, need_cueon;
  
protected:

  // filename
  
  char fname[255];
  
  // default command for rendering file
  
  char renderCommand[255];

  // object color
  
  float currentColor[3];

  // Has the view matrix changes since last time we looked?

  int viewChanged;
  
  // various generic graphics commands

  void set_line_width(int);
  void set_line_style(int);
  void set_color(float *);
  void define_light(int, float *, float *);
  void light_onoff(int, int);
  float scale_radius(float);
  
  // various virtual generic graphics commands

  virtual int do_define_material(int, float *);
  virtual void point(float *);
  virtual void sphere(float *);
  virtual void line(float *, float *);
  virtual void cylinder(float *, float *, float);
  virtual void cone(float *, float *, float);
  virtual void triangle(float *, float *, float *, float *, float *, float *);
  virtual void square(float *, float *, float *, float *, float *);
  virtual void text(char *);
  virtual void text_position(float, float, float);
  virtual void activate_materials(void);
  virtual void deactivate_materials(void);

public:
  
  
  // constructor/destructor
  FileRenderer(char *);
  virtual ~FileRenderer(void);
  
  // get/set the filename
  void set_filename(char *);
  const char *get_filename(void);
  
  // return the default render command line
  const char *default_render(void);
  
  // basic rendering functions
  virtual void prepare3D(int = TRUE) = 0;
  virtual void update(int = TRUE) = 0;
  virtual void render(void *);
     
};

#endif

