/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: GeometryAngle.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.3 $      $Date: 1995/05/11 22:59:05 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Measures the angle between three atoms, and draws a marker for the angle
 * into the display list for a given Displayable.
 *
 ***************************************************************************/
#ifndef GEOMETRYANGLE_H
#define GEOMETRYANGLE_H

#include "GeometryMol.h"


class GeometryAngle : public GeometryMol {

public:
  // constructor: molecule id's, atom indices, molecule list
  GeometryAngle(int *, int *, MoleculeList *);
  
  //
  // public virtual routines
  //
  
  // recalculate the value of this geometry, and return it
  virtual float calculate(void);
  
  // draw the geometry marker in the given Displayable's drawing list
  virtual void draw_marker(Displayable *);

};

#endif

