/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: GeometryAtom.C,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.4 $      $Date: 1995/05/11 22:59:06 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Draws a marker for a specified atom into the display list for a Displayable
 *
 ***************************************************************************/

#include "GeometryAtom.h"
#include "MoleculeList.h"
#include "Molecule.h"


////////////////////////  constructor  /////////////////////////
GeometryAtom::GeometryAtom(int m, int a, MoleculeList *mlist)
	: GeometryMol(1, &m, &a, mlist) {

  // indicate this object does not have a value
  hasValue = FALSE;
}



////////////////////  public virtual routines  //////////////////////

// draw the geometry marker in the given Displayable's drawing list
void GeometryAtom::draw_marker(Displayable *d) {

  // get the molecule pointer and atom position
  Molecule *mol = transformed_atom_coord(objIndex[0], comIndex[0], valuePos);
  
  // do not draw if illegal molecule, or atom is not on
  if(!mol)
    return;

  // everything is OK, draw text at atom position
  display_string(mol->atom_short_name(comIndex[0]), d);
}

