/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: GeometryTug.h,v $
 *	$Author: leech $		$Locker:  $		   $State: Exp $
 *	$Revision: 1.1 $	      $Date: 1995/05/16 20:54:41 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Draws a tug between an atom and a specified position
 * into the display list for a given Displayable.
 *
 ***************************************************************************/
#ifndef GEOMETRYTUG_H
#define GEOMETRYTUG_H

#include "GeometryMol.h"

class GeometryTug : public GeometryMol {
protected:
  float tugPos[3];

public:
  // constructor: molecule id, atom id, position, molecule list
  GeometryTug(int, int, float *, MoleculeList *);

  // set/inquire tug position
  void setTugPos(const float *);
  void getTugPos(float *);

  //
  // public virtual routines
  //

  // recalculate the value of this geometry, and return it
  virtual float calculate(void);

  // draw the geometry marker in the given Displayable's drawing list
  virtual void draw_marker(Displayable *);
};

#endif

